/**
 ********************************************************************************
 *** BaseRedirectUrlAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.anosite.gen.shared.action.BaseSitexAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrl;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseRedirectUrlAction extends BaseSitexAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "RedirectUrl";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "RedirectUrl";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, RedirectUrl redirecturl) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteData.RedirectUrl").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.RedirectUrl", redirecturl, "in");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.in", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.RedirectUrl", redirecturl, "out");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.out", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockRedirectUrls(RedirectUrl redirecturl, HttpServletRequest req) throws Exception{
		if(redirecturl instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)redirecturl;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteDataService().updateRedirectUrl( redirecturl);
			logger.info("Lock-OPERATION, document with id : ["+redirecturl.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockRedirectUrls(RedirectUrl redirecturl, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(redirecturl instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)redirecturl;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteDataService().updateRedirectUrl( redirecturl);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+redirecturl.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+redirecturl.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkRedirectUrls(RedirectUrl redirecturl, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = redirecturl instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)redirecturl).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)redirecturl).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockRedirectUrls(redirecturl, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateRedirectUrls(RedirectUrl redirecturl, HttpServletRequest req) throws Exception{
		if(redirecturl instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)redirecturl, false, getUserId(req));
		}
		if (isTimeoutReached(redirecturl)) {
			checkRedirectUrls(redirecturl, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(redirecturl, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(RedirectUrl redirecturl){
		if (redirecturl instanceof LockableObject) {
			LockableObject lock = (LockableObject)redirecturl;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(RedirectUrl redirecturl, HttpServletRequest req){
		if (redirecturl instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)redirecturl;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
