/**
 ********************************************************************************
 *** EditSiteAction.java                                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.bean.EditSiteFB;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.asg.data.MultilingualObject;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.util.bean.LinkToMeBean;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.asresourcedata.data.Image;

public class EditSiteAction extends ShowSitesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditAction

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditActionMethod

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		EditSiteFB form = new EditSiteFB() ;
		Site site = getASSiteDataService().getSite(id);
		checkSites(site, req);
		if(site instanceof LockableObject && !((LockableObject)site).isLocked() && isAutoLockingEnabled())
			lockSites(site, req);
		form.setId(site.getId());
		form.setName(site.getName());
		form.setTitleEN(site.getTitleEN());
		form.setSubtitleEN(site.getSubtitleEN());
		form.setKeywordsEN(site.getKeywordsEN());
		form.setDescriptionEN(site.getDescriptionEN());
		// topNavi is a table, storing size only
		form.setTopNavi(site.getTopNaviSize());
		// mainNavi is a table, storing size only
		form.setMainNavi(site.getMainNaviSize());
		form.setStartpage(site.getStartpage());
		form.setSearchpage(site.getSearchpage());
		form.setLanguageselector(site.getLanguageselector());
		form.setHeaderBackground(site.getHeaderBackground());
		form.setSiteLogo(site.getSiteLogo());
		form.setMultilingualInstanceDisabled(((MultilingualObject)site).isMultilingualDisabledInstance());
		form.setLocked(((LockableObject)site).isLocked());
		form.setLockerId(((LockableObject)site).getLockerId());
		form.setLockingTime(net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)site).getLockingTime()) + " automatic unlock expected AT : " + net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)site).getLockingTime() + getLockingTimeout()));


		//link startpage to ASWebData.Pagex
		List<Pagex> pagexs = getASWebDataService().getPagexs();
		List<LabelValueBean> pagexsValues = new ArrayList<LabelValueBean>(pagexs.size()+1);
		pagexsValues.add(new LabelValueBean("", "-----"));
		for (net.anotheria.anosite.gen.aswebdata.data.Pagex pagexTemp : pagexs){
			LabelValueBean bean = new LabelValueBean(pagexTemp.getId(), pagexTemp.getName() + " [" + pagexTemp.getId() + "]" );
			pagexsValues.add(bean);
		}
		form.setStartpageCollection(pagexsValues);
		try{
			form.setStartpageCurrentValue(getASWebDataService().getPagex(site.getStartpage()).getName());
		}catch(Exception e){
			form.setStartpageCurrentValue("none");
			form.setStartpageIdOfCurrentValue("none");
		}

		//reusing collection for searchpage to ASWebData.Pagex.
		form.setSearchpageCollection(pagexsValues);
		try{
			form.setSearchpageCurrentValue(getASWebDataService().getPagex(site.getSearchpage()).getName());
		}catch(Exception e){
			form.setSearchpageCurrentValue("none");
			form.setSearchpageIdOfCurrentValue("none");
		}

		//link headerBackground to ASResourceData.Image
		List<Image> images = getASResourceDataService().getImages();
		List<LabelValueBean> imagesValues = new ArrayList<LabelValueBean>(images.size()+1);
		imagesValues.add(new LabelValueBean("", "-----"));
		for (net.anotheria.anosite.gen.asresourcedata.data.Image imageTemp : images){
			LabelValueBean bean = new LabelValueBean(imageTemp.getId(), imageTemp.getName() + " [" + imageTemp.getId() + "]" );
			imagesValues.add(bean);
		}
		form.setHeaderBackgroundCollection(imagesValues);
		try{
			form.setHeaderBackgroundCurrentValue(getASResourceDataService().getImage(site.getHeaderBackground()).getName());
		}catch(Exception e){
			form.setHeaderBackgroundCurrentValue("none");
			form.setHeaderBackgroundIdOfCurrentValue("none");
		}

		//reusing collection for siteLogo to ASResourceData.Image.
		form.setSiteLogoCollection(imagesValues);
		try{
			form.setSiteLogoCurrentValue(getASResourceDataService().getImage(site.getSiteLogo()).getName());
		}catch(Exception e){
			form.setSiteLogoCurrentValue("none");
			form.setSiteLogoIdOfCurrentValue("none");
		}
		addBeanToRequest(req, "objectId" , site.getId());
		addBeanToRequest(req, "EditASSiteDataSiteForm" , form);
		addBeanToRequest(req, "objectInfoString" , site.getObjectInfo().toString());
		addBeanToRequest(req, "apply.label.prefix", "Apply");
		addBeanToRequest(req, "save.label.prefix", "Save");

		addFieldExplanations(req, site);


		// Generating back link handling...
		List<LinkToMeBean> linksToMe = findLinksToCurrentDocument(site.getId());
		if (linksToMe.size()>0)
			req.setAttribute("linksToMe", linksToMe);
		return mapping.success();
	}

	private List<LinkToMeBean> findLinksToCurrentDocument(String documentId){
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataPageTemplateSite(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataEntryPointStartSite(documentId));
		}catch(Exception ignored){
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataPageTemplateSite(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(PageTemplate.LINK_PROP_SITE, documentId);
		// temporarly - replacy with query property
		List<PageTemplate> list = getASSiteDataService().getPageTemplatesByProperty(p.getName(), p.getValue());
		for (PageTemplate doc : list ){
			ret.add(new LinkToMeBean(doc, "site"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataEntryPointStartSite(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(EntryPoint.LINK_PROP_START_SITE, documentId);
		// temporarly - replacy with query property
		List<EntryPoint> list = getASSiteDataService().getEntryPointsByProperty(p.getName(), p.getValue());
		for (EntryPoint doc : list ){
			ret.add(new LinkToMeBean(doc, "startSite"));
		}
		return ret;
	}
}
