/**
 ********************************************************************************
 *** ExportRedirectUrlsAction.java                                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrl;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrlSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.assitedata.bean.RedirectUrlListItemBeanSortType;

public class ExportRedirectUrlsAction extends BaseRedirectUrlAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"RedirectUrl";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"RedirectUrl";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportRedirectUrlsAction.class);
	private Sorter<RedirectUrl> sorter;

	public ExportRedirectUrlsAction(){
		super();
		sorter = new QuickSorter<RedirectUrl>();
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		int sortMethod = RedirectUrlListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = RedirectUrlListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = RedirectUrlListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				RedirectUrlListItemBeanSortType.ASC : RedirectUrlListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		RedirectUrlListItemBeanSortType sessionSortType  = null;
		RedirectUrlSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new RedirectUrlListItemBeanSortType(sortMethod, sortOrder);
			sortType = new RedirectUrlSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (RedirectUrlListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new RedirectUrlSortType(sortMethod, sortOrder) : new RedirectUrlSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new RedirectUrlListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<RedirectUrl> redirecturls = getASSiteDataService().getRedirectUrls();
		redirecturls = sorter.sort(redirecturls, sortType);

		addBeanToRequest(req, "redirecturls", redirecturls);

		XMLNode beans = getASSiteDataService().exportRedirectUrlsToXML(redirecturls);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "redirecturlsXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "redirecturlsCSV", redirecturls);
		return mapping.success();
	}

}
