/**
 ********************************************************************************
 *** MultiOpDialogPageAliassAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.data.PageAliasFactory;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.anosite.gen.assitedata.bean.EditPageAliasFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogPageAliassAction extends BasePageAliasAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataPageAliasDelete"))
			return assitedataPageAliasDelete(mapping, req, res);
		if (path.equals("assitedataPageAliasDuplicate"))
			return assitedataPageAliasDuplicate(mapping, req, res);
		if (path.equals("assitedataPageAliasUpdate"))
			return assitedataPageAliasUpdate(mapping, req, res);
		if (path.equals("assitedataPageAliasClose"))
			return assitedataPageAliasClose(mapping, req, res);
		if (path.equals("assitedataPageAliasLock"))
			return assitedataPageAliasLock(mapping, req, res);
		if (path.equals("assitedataPageAliasUnLock"))
			return assitedataPageAliasUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assitedataPageAliasDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			PageAlias pagealiasCurr = getASSiteDataService().getPageAlias(id);
			if (pagealiasCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)pagealiasCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteDataService().deletePageAlias(id);
		}
		res.sendRedirect("assitedataPageAliasShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assitedataPageAliasDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		PageAlias pagealiasSrc = getASSiteDataService().getPageAlias(id);
		PageAlias pagealiasDest = PageAliasFactory.createPageAlias(pagealiasSrc);



		PageAlias pagealiasCreated = getASSiteDataService().createPageAlias(pagealiasDest);
		res.sendRedirect("assitedataPageAliasEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+pagealiasCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assitedataPageAliasUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditPageAliasFB form = new EditPageAliasFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		PageAlias pagealias = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		pagealias = (PageAlias)getASSiteDataService().getPageAlias(form.getId()).clone();
	}else{
		pagealias = PageAliasFactory.createPageAlias();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	pagealias.setName(form.getName());
	pagealias.setTargetPage(form.getTargetPage());
	pagealias.setParameters(form.getParameters());
	pagealias.setType(form.getType());
	// skipped container pathes

	PageAlias updatedCopy = null;
	if (create){
		updatedCopy = getASSiteDataService().createPageAlias(pagealias);
	}else{
		canUpdatePageAliass(pagealias, req);
		checkPageAliass(pagealias, req);
		updatedCopy = getASSiteDataService().updatePageAlias(pagealias);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assitedataPageAliasEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(pagealias, req);
		res.sendRedirect("assitedataPageAliasShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(PageAlias pagealias, HttpServletRequest req) throws Exception{
	if(((LockableObject)pagealias).isLocked())
		unLockPageAliass(pagealias, req, false);
}

public ActionCommand assitedataPageAliasLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageAlias pagealiasCurr = id != null && !id.equals("") ? getASSiteDataService().getPageAlias(id) : null;
	if(pagealiasCurr != null && pagealiasCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagealiasCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockPageAliass(pagealiasCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, pagealiasCurr));
	return null;
}

public ActionCommand assitedataPageAliasUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageAlias pagealiasCurr = id != null && !id.equals("") ? getASSiteDataService().getPageAlias(id) : null;
	if(pagealiasCurr != null && pagealiasCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagealiasCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockPageAliass(pagealiasCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, pagealiasCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, PageAlias item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assitedataPageAliasShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assitedataPageAliasEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assitedataPageAliasShow?ts="+System.currentTimeMillis();
}

public ActionCommand assitedataPageAliasClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageAlias pagealiasCurr = id != null && !id.equals("") ? getASSiteDataService().getPageAlias(id) : null;
	if(pagealiasCurr != null && pagealiasCurr instanceof LockableObject && ((LockableObject)pagealiasCurr).isLocked()) 
		unLockPageAliass(pagealiasCurr, req, false);
	res.sendRedirect("assitedataPageAliasShow?ts="+System.currentTimeMillis());
	return null;
}

}
