/**
 ********************************************************************************
 *** MultiOpDialogRedirectUrlsAction.java                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrlFactory;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrl;
import net.anotheria.anosite.gen.assitedata.bean.EditRedirectUrlFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogRedirectUrlsAction extends BaseRedirectUrlAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataRedirectUrlDelete"))
			return assitedataRedirectUrlDelete(mapping, req, res);
		if (path.equals("assitedataRedirectUrlDuplicate"))
			return assitedataRedirectUrlDuplicate(mapping, req, res);
		if (path.equals("assitedataRedirectUrlUpdate"))
			return assitedataRedirectUrlUpdate(mapping, req, res);
		if (path.equals("assitedataRedirectUrlClose"))
			return assitedataRedirectUrlClose(mapping, req, res);
		if (path.equals("assitedataRedirectUrlLock"))
			return assitedataRedirectUrlLock(mapping, req, res);
		if (path.equals("assitedataRedirectUrlUnLock"))
			return assitedataRedirectUrlUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assitedataRedirectUrlDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			RedirectUrl redirecturlCurr = getASSiteDataService().getRedirectUrl(id);
			if (redirecturlCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)redirecturlCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteDataService().deleteRedirectUrl(id);
		}
		res.sendRedirect("assitedataRedirectUrlShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assitedataRedirectUrlDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		RedirectUrl redirecturlSrc = getASSiteDataService().getRedirectUrl(id);
		RedirectUrl redirecturlDest = RedirectUrlFactory.createRedirectUrl(redirecturlSrc);


		RedirectUrl redirecturlCreated = getASSiteDataService().createRedirectUrl(redirecturlDest);
		res.sendRedirect("assitedataRedirectUrlEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+redirecturlCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assitedataRedirectUrlUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditRedirectUrlFB form = new EditRedirectUrlFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		RedirectUrl redirecturl = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		redirecturl = (RedirectUrl)getASSiteDataService().getRedirectUrl(form.getId()).clone();
	}else{
		redirecturl = RedirectUrlFactory.createRedirectUrl();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	redirecturl.setIn(form.getIn());
	redirecturl.setOut(form.getOut());

	RedirectUrl updatedCopy = null;
	if (create){
		updatedCopy = getASSiteDataService().createRedirectUrl(redirecturl);
	}else{
		canUpdateRedirectUrls(redirecturl, req);
		checkRedirectUrls(redirecturl, req);
		updatedCopy = getASSiteDataService().updateRedirectUrl(redirecturl);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assitedataRedirectUrlEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(redirecturl, req);
		res.sendRedirect("assitedataRedirectUrlShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(RedirectUrl redirecturl, HttpServletRequest req) throws Exception{
	if(((LockableObject)redirecturl).isLocked())
		unLockRedirectUrls(redirecturl, req, false);
}

public ActionCommand assitedataRedirectUrlLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	RedirectUrl redirecturlCurr = id != null && !id.equals("") ? getASSiteDataService().getRedirectUrl(id) : null;
	if(redirecturlCurr != null && redirecturlCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)redirecturlCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockRedirectUrls(redirecturlCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, redirecturlCurr));
	return null;
}

public ActionCommand assitedataRedirectUrlUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	RedirectUrl redirecturlCurr = id != null && !id.equals("") ? getASSiteDataService().getRedirectUrl(id) : null;
	if(redirecturlCurr != null && redirecturlCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)redirecturlCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockRedirectUrls(redirecturlCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, redirecturlCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, RedirectUrl item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assitedataRedirectUrlShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assitedataRedirectUrlEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assitedataRedirectUrlShow?ts="+System.currentTimeMillis();
}

public ActionCommand assitedataRedirectUrlClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	RedirectUrl redirecturlCurr = id != null && !id.equals("") ? getASSiteDataService().getRedirectUrl(id) : null;
	if(redirecturlCurr != null && redirecturlCurr instanceof LockableObject && ((LockableObject)redirecturlCurr).isLocked()) 
		unLockRedirectUrls(redirecturlCurr, req, false);
	res.sendRedirect("assitedataRedirectUrlShow?ts="+System.currentTimeMillis());
	return null;
}

}
