/**
 ********************************************************************************
 *** MultiOpDialogSitesAction.java                                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.data.SiteFactory;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.bean.EditSiteFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;

public class MultiOpDialogSitesAction extends BaseSiteAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataSiteDelete"))
			return assitedataSiteDelete(mapping, req, res);
		if (path.equals("assitedataSiteDuplicate"))
			return assitedataSiteDuplicate(mapping, req, res);
		if (path.equals("assitedataSiteUpdate"))
			return assitedataSiteUpdate(mapping, req, res);
		if (path.equals("assitedataSiteClose"))
			return assitedataSiteClose(mapping, req, res);
		if (path.equals("assitedataSiteCopyLang"))
			return assitedataSiteCopyLang(mapping, req, res);
		if (path.equals("assitedataSiteSwitchMultilang"))
			return assitedataSiteSwitchMultilang(mapping, req, res);
		if (path.equals("assitedataSiteLock"))
			return assitedataSiteLock(mapping, req, res);
		if (path.equals("assitedataSiteUnLock"))
			return assitedataSiteUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assitedataSiteDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Site siteCurr = getASSiteDataService().getSite(id);
			if (siteCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)siteCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteDataService().deleteSite(id);
		}
		res.sendRedirect("assitedataSiteShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assitedataSiteDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Site siteSrc = getASSiteDataService().getSite(id);
		Site siteDest = SiteFactory.createSite(siteSrc);




		Site siteCreated = getASSiteDataService().createSite(siteDest);
		res.sendRedirect("assitedataSiteEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+siteCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assitedataSiteUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditSiteFB form = new EditSiteFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Site site = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		site = (Site)getASSiteDataService().getSite(form.getId()).clone();
	}else{
		site = SiteFactory.createSite();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	site.setName(form.getName());
	site.setTitleEN(form.getTitleEN());
	site.setSubtitleEN(form.getSubtitleEN());
	site.setKeywordsEN(form.getKeywordsEN());
	site.setDescriptionEN(form.getDescriptionEN());
	// skipped container topNavi
	// skipped container mainNavi
	site.setStartpage(form.getStartpage());
	site.setSearchpage(form.getSearchpage());
	site.setLanguageselector(form.isLanguageselector());
	site.setHeaderBackground(form.getHeaderBackground());
	site.setSiteLogo(form.getSiteLogo());

	Site updatedCopy = null;
	if (create){
		updatedCopy = getASSiteDataService().createSite(site);
	}else{
		canUpdateSites(site, req);
		checkSites(site, req);
		updatedCopy = getASSiteDataService().updateSite(site);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assitedataSiteEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(site, req);
		res.sendRedirect("assitedataSiteShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Site site, HttpServletRequest req) throws Exception{
	if(((LockableObject)site).isLocked())
		unLockSites(site, req, false);
}

public ActionCommand assitedataSiteCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	Site site = getASSiteDataService().getSite(id);
	canUpdateSites(site, req);
	checkSites(site, req);
	site.copyLANG2LANG(sourceLanguage, destLanguage);
	getASSiteDataService().updateSite(site);
	res.sendRedirect("assitedataSiteEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand assitedataSiteSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	Site site = getASSiteDataService().getSite(id);
	canUpdateSites(site, req);
	checkSites(site, req);
	((MultilingualObject)site).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASSiteDataService().updateSite(site);
	res.sendRedirect("assitedataSiteEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand assitedataSiteLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Site siteCurr = id != null && !id.equals("") ? getASSiteDataService().getSite(id) : null;
	if(siteCurr != null && siteCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)siteCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockSites(siteCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, siteCurr));
	return null;
}

public ActionCommand assitedataSiteUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Site siteCurr = id != null && !id.equals("") ? getASSiteDataService().getSite(id) : null;
	if(siteCurr != null && siteCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)siteCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockSites(siteCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, siteCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Site item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assitedataSiteShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assitedataSiteEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assitedataSiteShow?ts="+System.currentTimeMillis();
}

public ActionCommand assitedataSiteClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Site siteCurr = id != null && !id.equals("") ? getASSiteDataService().getSite(id) : null;
	if(siteCurr != null && siteCurr instanceof LockableObject && ((LockableObject)siteCurr).isLocked()) 
		unLockSites(siteCurr, req, false);
	res.sendRedirect("assitedataSiteShow?ts="+System.currentTimeMillis());
	return null;
}

}
