/**
 ********************************************************************************
 *** MultiOpSitesTopNaviAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.SiteFactory;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.bean.TopNaviElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.assitedata.bean.TopNaviQuickAddFB;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.data.NaviItemSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpSitesTopNaviAction extends BaseSiteAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataSiteTopNaviShow"))
			return assitedataSiteTopNaviShow(mapping, req, res);
		if (path.equals("assitedataSiteTopNaviAdd"))
			return assitedataSiteTopNaviAdd(mapping, req, res);
		if (path.equals("assitedataSiteTopNaviDelete"))
			return assitedataSiteTopNaviDelete(mapping, req, res);
		if (path.equals("assitedataSiteTopNaviMove"))
			return assitedataSiteTopNaviMove(mapping, req, res);
		if (path.equals("assitedataSiteTopNaviQuickAdd"))
			return assitedataSiteTopNaviQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand assitedataSiteTopNaviShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Site site = getASSiteDataService().getSite(id);
		addBeanToRequest(req, "ownerId", id);
		checkSites(site, req);

		TopNaviElementFB form = new TopNaviElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(site.getId());
		addBeanToRequest(req, "assitedataSiteTopNaviElementForm", form);

		TopNaviQuickAddFB quickAddForm = new TopNaviQuickAddFB() ;
		quickAddForm.setOwnerId(site.getId());
		addBeanToRequest(req, "assitedataSiteTopNaviQuickAddForm", quickAddForm);


		//link item to ASSiteData.NaviItem
		List<NaviItem> naviitems = getASSiteDataService().getNaviItems(new NaviItemSortType(NaviItemSortType.SORT_BY_NAME));
		List<LabelValueBean> naviitemsValues = new ArrayList<LabelValueBean>(naviitems.size());
		for (int i=0; i<naviitems.size(); i++){
			net.anotheria.anosite.gen.assitedata.data.NaviItem tmp_naviitem = (net.anotheria.anosite.gen.assitedata.data.NaviItem) naviitems.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_naviitem.getId(), tmp_naviitem.getName()+" ["+tmp_naviitem.getId()+"]" );
			naviitemsValues.add(bean);
		}
		addBeanToRequest(req, "itemValuesCollection", naviitemsValues);
		// generate list ...
		int size = site.getTopNaviSize();
		List<TopNaviElementFB> beans = new ArrayList<TopNaviElementFB>(size);
		for (int i=0; i<size; i++){
			String value = site.getTopNaviElement(i);
			TopNaviElementFB bean = new TopNaviElementFB();
			bean.setOwnerId(site.getId());
			bean.setPosition(i);
			bean.setItem(value);
			try{
				NaviItem tmp_naviitem = getASSiteDataService().getNaviItem(value);
				bean.setDescription(tmp_naviitem.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand assitedataSiteTopNaviDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Site siteCurr = getASSiteDataService().getSite(id);
		canUpdateSites(siteCurr, req);
		checkSites(siteCurr, req);
		int position = getIntParameter(req, "pPosition");
		Site site = getASSiteDataService().getSite(id);
		site.removeTopNaviElement(position);
		getASSiteDataService().updateSite(site);
		return assitedataSiteTopNaviShow(mapping, req, res);
	}

	public ActionCommand assitedataSiteTopNaviMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Site site = getASSiteDataService().getSite(id);
		canUpdateSites(site, req);
		checkSites(site, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(site, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(site, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(site, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(site, position);
		return assitedataSiteTopNaviShow(mapping, req, res);
	}

	private void moveUp(Site site, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		site.swapTopNaviElement(position, position-1);
		getASSiteDataService().updateSite(site);
	}

	private void moveTop(Site site, int position) throws ASGRuntimeException {
		List<String> targetList = site.getTopNavi();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		site.setTopNavi(targetList);
		getASSiteDataService().updateSite(site);
	}

	private void moveDown(Site site, int position) throws ASGRuntimeException {
		if (position<site.getTopNaviSize()-1){
			site.swapTopNaviElement(position, position+1);
			getASSiteDataService().updateSite(site);
		}
	}

	private void moveBottom(Site site, int position) throws ASGRuntimeException {
		List<String> targetList = site.getTopNavi();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		site.setTopNavi(targetList);
		getASSiteDataService().updateSite(site);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand assitedataSiteTopNaviAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		TopNaviElementFB form = new TopNaviElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Site site;
		site = getASSiteDataService().getSite(id);
		canUpdateSites(site, req);
		checkSites(site, req);
		site.addTopNaviElement(form.getItem());
		getASSiteDataService().updateSite(site);
		return assitedataSiteTopNaviShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand assitedataSiteTopNaviQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		TopNaviQuickAddFB form = new TopNaviQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Site site;
		site = getASSiteDataService().getSite(id);
		canUpdateSites(site, req);
		checkSites(site, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				site.addTopNaviElement(""+i);
			}
		}
		getASSiteDataService().updateSite(site);
		return assitedataSiteTopNaviShow(mapping, req, res);
	}

}
