/**
 ********************************************************************************
 *** ShowNaviItemsAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.bean.NaviItemListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.assitedata.bean.NaviItemListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowNaviItemsAction extends BaseNaviItemAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"NaviItem";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"NaviItem";
	private static Logger log = LoggerFactory.getLogger(ShowNaviItemsAction.class);
	private Sorter<NaviItemListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator internalLinkDecorator;
	private IAttributeDecorator pageAliasDecorator;
	private IAttributeDecorator subNaviDecorator;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ShowNaviItemsAction(){
		sorter = new QuickSorter<NaviItemListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			internalLinkDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
			pageAliasDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
			subNaviDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.NaviItemCMS2Decorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = NaviItemListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = NaviItemListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		NaviItemListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new NaviItemListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (NaviItemListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new NaviItemListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<NaviItem> _unfiltered_naviitems = getASSiteDataService().getNaviItems();
		List<NaviItem> naviitems = new ArrayList<NaviItem>();
		for (int i=0; i<_unfiltered_naviitems.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_naviitems.get(i), "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass(_unfiltered_naviitems.get(i), "Any", filterParameter1));
			if (mayPass)
				naviitems.add(_unfiltered_naviitems.get(i));
		}
		List<NaviItemListItemBean> beans = new ArrayList<NaviItemListItemBean>(naviitems.size());
		for (NaviItem naviitem : naviitems){
			checkNaviItems(naviitem, req);
			NaviItemListItemBean bean = makeNaviItemListItemBean(naviitem);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "naviitems", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer("Any"));
		return mapping.success();
	}

	protected NaviItemListItemBean makeNaviItemListItemBean(NaviItem naviitem) {
		NaviItemListItemBean bean = new NaviItemListItemBean();
		bean.setPlainId(naviitem.getId());
		bean.setIdForSorting(naviitem.getId());
		bean.setId(idDecorator.decorate(naviitem, "id", "3"));
		bean.setNameForSortingEN(naviitem.getNameEN());
		bean.setNameEN(nameDecorator.decorate(naviitem, "name_EN", "null"));
		bean.setExternalLink(naviitem.getExternalLink());
		bean.setInternalLinkForSorting(naviitem.getInternalLink());
		bean.setInternalLink(internalLinkDecorator.decorate(naviitem, "internalLink", "null"));
		bean.setPageAliasForSorting(naviitem.getPageAlias());
		bean.setPageAlias(pageAliasDecorator.decorate(naviitem, "pageAlias", "null"));
		bean.setClassName(naviitem.getClassName());
		bean.setSubNaviForSorting(naviitem.getSubNavi());
		bean.setSubNavi(subNaviDecorator.decorate(naviitem, "subNavi", "null"));
		bean.setPopup(naviitem.getPopup());
		bean.setLocked(((LockableObject)naviitem).isLocked());
		bean.setLockerId(((LockableObject)naviitem).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)naviitem).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)naviitem).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(naviitem.getLastUpdateTimestamp()));
		return bean;
	}
}
