/**
 ********************************************************************************
 *** ShowPageTemplatesAction.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.bean.PageTemplateListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.assitedata.bean.PageTemplateListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowPageTemplatesAction extends BasePageTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"PageTemplate";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"PageTemplate";
	private static Logger log = LoggerFactory.getLogger(ShowPageTemplatesAction.class);
	private Sorter<PageTemplateListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator layoutDecorator;
	private IAttributeDecorator siteDecorator;
	private IAttributeDecorator c1firstDecorator;
	private IAttributeDecorator c2firstDecorator;
	private IAttributeDecorator c3firstDecorator;
	private IAttributeDecorator c1lastDecorator;
	private IAttributeDecorator c2lastDecorator;
	private IAttributeDecorator c3lastDecorator;
	private IAttributeDecorator metaDecorator;
	private IAttributeDecorator headerDecorator;
	private IAttributeDecorator footerDecorator;
	private IAttributeDecorator mediaLinksDecorator;
	private IAttributeDecorator scriptsDecorator;
	private IAttributeDecorator localizationsDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowPageTemplatesAction(){
		sorter = new QuickSorter<PageTemplateListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			layoutDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
			siteDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
			c1firstDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			c2firstDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			c3firstDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			c1lastDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			c2lastDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			c3lastDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			metaDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			headerDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			footerDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			mediaLinksDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.MediaLinksListCMS2Decorator").newInstance();
			scriptsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.ScriptsListCMS2Decorator").newInstance();
			localizationsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LocalizationsListCMS2Decorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = PageTemplateListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PageTemplateListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		PageTemplateListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new PageTemplateListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (PageTemplateListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new PageTemplateListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<PageTemplate> _unfiltered_pagetemplates = getASSiteDataService().getPageTemplates();
		List<PageTemplate> pagetemplates = new ArrayList<PageTemplate>();
		for (int i=0; i<_unfiltered_pagetemplates.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_pagetemplates.get(i), "name", filterParameter0));
			if (mayPass)
				pagetemplates.add(_unfiltered_pagetemplates.get(i));
		}
		List<PageTemplateListItemBean> beans = new ArrayList<PageTemplateListItemBean>(pagetemplates.size());
		for (PageTemplate pagetemplate : pagetemplates){
			checkPageTemplates(pagetemplate, req);
			PageTemplateListItemBean bean = makePageTemplateListItemBean(pagetemplate);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "pagetemplates", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected PageTemplateListItemBean makePageTemplateListItemBean(PageTemplate pagetemplate) {
		PageTemplateListItemBean bean = new PageTemplateListItemBean();
		bean.setPlainId(pagetemplate.getId());
		bean.setIdForSorting(pagetemplate.getId());
		bean.setId(idDecorator.decorate(pagetemplate, "id", "3"));
		bean.setNameForSorting(pagetemplate.getName());
		bean.setName(nameDecorator.decorate(pagetemplate, "name", "null"));
		bean.setLayoutForSorting(pagetemplate.getLayout());
		bean.setLayout(layoutDecorator.decorate(pagetemplate, "layout", "null"));
		bean.setSiteForSorting(pagetemplate.getSite());
		bean.setSite(siteDecorator.decorate(pagetemplate, "site", "null"));
		bean.setC1firstForSorting(pagetemplate.getC1first());
		bean.setC1first(c1firstDecorator.decorate(pagetemplate, "c1first", "null"));
		bean.setC2firstForSorting(pagetemplate.getC2first());
		bean.setC2first(c2firstDecorator.decorate(pagetemplate, "c2first", "null"));
		bean.setC3firstForSorting(pagetemplate.getC3first());
		bean.setC3first(c3firstDecorator.decorate(pagetemplate, "c3first", "null"));
		bean.setC1lastForSorting(pagetemplate.getC1last());
		bean.setC1last(c1lastDecorator.decorate(pagetemplate, "c1last", "null"));
		bean.setC2lastForSorting(pagetemplate.getC2last());
		bean.setC2last(c2lastDecorator.decorate(pagetemplate, "c2last", "null"));
		bean.setC3lastForSorting(pagetemplate.getC3last());
		bean.setC3last(c3lastDecorator.decorate(pagetemplate, "c3last", "null"));
		bean.setMetaForSorting(pagetemplate.getMeta());
		bean.setMeta(metaDecorator.decorate(pagetemplate, "meta", "null"));
		bean.setHeaderForSorting(pagetemplate.getHeader());
		bean.setHeader(headerDecorator.decorate(pagetemplate, "header", "null"));
		bean.setFooterForSorting(pagetemplate.getFooter());
		bean.setFooter(footerDecorator.decorate(pagetemplate, "footer", "null"));
		bean.setMediaLinksForSorting(pagetemplate.getMediaLinks());
		bean.setMediaLinks(mediaLinksDecorator.decorate(pagetemplate, "mediaLinks", "null"));
		bean.setScriptsForSorting(pagetemplate.getScripts());
		bean.setScripts(scriptsDecorator.decorate(pagetemplate, "scripts", "null"));
		bean.setLocalizationsForSorting(pagetemplate.getLocalizations());
		bean.setLocalizations(localizationsDecorator.decorate(pagetemplate, "localizations", "null"));
		bean.setLocked(((LockableObject)pagetemplate).isLocked());
		bean.setLockerId(((LockableObject)pagetemplate).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)pagetemplate).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)pagetemplate).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(pagetemplate.getLastUpdateTimestamp()));
		return bean;
	}
}
