/**
 ********************************************************************************
 *** ShowRedirectUrlsAction.java                                              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.RedirectUrl;
import net.anotheria.anosite.gen.assitedata.bean.RedirectUrlListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.assitedata.bean.RedirectUrlListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowRedirectUrlsAction extends BaseRedirectUrlAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"RedirectUrl";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"RedirectUrl";
	private static Logger log = LoggerFactory.getLogger(ShowRedirectUrlsAction.class);
	private Sorter<RedirectUrlListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator inDecorator;
	private IAttributeDecorator outDecorator;

	public ShowRedirectUrlsAction(){
		sorter = new QuickSorter<RedirectUrlListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			inDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			outDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		int sortMethod = RedirectUrlListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = RedirectUrlListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		RedirectUrlListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new RedirectUrlListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (RedirectUrlListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new RedirectUrlListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<RedirectUrl> redirecturls = getASSiteDataService().getRedirectUrls();
		List<RedirectUrlListItemBean> beans = new ArrayList<RedirectUrlListItemBean>(redirecturls.size());
		for (RedirectUrl redirecturl : redirecturls){
			checkRedirectUrls(redirecturl, req);
			RedirectUrlListItemBean bean = makeRedirectUrlListItemBean(redirecturl);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "redirecturls", beans);
		return mapping.success();
	}

	protected RedirectUrlListItemBean makeRedirectUrlListItemBean(RedirectUrl redirecturl) {
		RedirectUrlListItemBean bean = new RedirectUrlListItemBean();
		bean.setPlainId(redirecturl.getId());
		bean.setIdForSorting(redirecturl.getId());
		bean.setId(idDecorator.decorate(redirecturl, "id", "3"));
		bean.setInForSorting(redirecturl.getIn());
		bean.setIn(inDecorator.decorate(redirecturl, "in", "null"));
		bean.setOutForSorting(redirecturl.getOut());
		bean.setOut(outDecorator.decorate(redirecturl, "out", "null"));
		bean.setLocked(((LockableObject)redirecturl).isLocked());
		bean.setLockerId(((LockableObject)redirecturl).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)redirecturl).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)redirecturl).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(redirecturl.getLastUpdateTimestamp()));
		return bean;
	}
}
