/**
 ********************************************************************************
 *** ShowSitesAction.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.bean.SiteListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.assitedata.bean.SiteListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowSitesAction extends BaseSiteAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Site";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Site";
	private static Logger log = LoggerFactory.getLogger(ShowSitesAction.class);
	private Sorter<SiteListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator topNaviDecorator;
	private IAttributeDecorator mainNaviDecorator;
	private IAttributeDecorator startpageDecorator;
	private IAttributeDecorator searchpageDecorator;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ShowSitesAction(){
		sorter = new QuickSorter<SiteListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			topNaviDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.NaviItemCMS2Decorator").newInstance();
			mainNaviDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.NaviItemCMS2Decorator").newInstance();
			startpageDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
			searchpageDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = SiteListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = SiteListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		SiteListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new SiteListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (SiteListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new SiteListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<Site> _unfiltered_sites = getASSiteDataService().getSites();
		List<Site> sites = new ArrayList<Site>();
		for (int i=0; i<_unfiltered_sites.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_sites.get(i), "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass(_unfiltered_sites.get(i), "Any", filterParameter1));
			if (mayPass)
				sites.add(_unfiltered_sites.get(i));
		}
		List<SiteListItemBean> beans = new ArrayList<SiteListItemBean>(sites.size());
		for (Site site : sites){
			checkSites(site, req);
			SiteListItemBean bean = makeSiteListItemBean(site);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "sites", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer("Any"));
		return mapping.success();
	}

	protected SiteListItemBean makeSiteListItemBean(Site site) {
		SiteListItemBean bean = new SiteListItemBean();
		bean.setPlainId(site.getId());
		bean.setIdForSorting(site.getId());
		bean.setId(idDecorator.decorate(site, "id", "3"));
		bean.setNameForSorting(site.getName());
		bean.setName(nameDecorator.decorate(site, "name", "null"));
		bean.setTitleEN(site.getTitleEN());
		bean.setTopNaviForSorting(site.getTopNavi());
		bean.setTopNavi(topNaviDecorator.decorate(site, "topNavi", "null"));
		bean.setMainNaviForSorting(site.getMainNavi());
		bean.setMainNavi(mainNaviDecorator.decorate(site, "mainNavi", "null"));
		bean.setStartpageForSorting(site.getStartpage());
		bean.setStartpage(startpageDecorator.decorate(site, "startpage", "null"));
		bean.setSearchpageForSorting(site.getSearchpage());
		bean.setSearchpage(searchpageDecorator.decorate(site, "searchpage", "null"));
		bean.setLocked(((LockableObject)site).isLocked());
		bean.setLockerId(((LockableObject)site).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)site).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)site).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(site.getLastUpdateTimestamp()));
		return bean;
	}
}
