/**
 ********************************************************************************
 *** EntryPointDocument.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class EntryPointDocument extends AbstractASGDocument implements EntryPoint, IComparable{

	public EntryPointDocument() {
		super("");
	}

	public EntryPointDocument(String id){
		super(id);
	}

	public EntryPointDocument(EntryPointDocument toClone){
		super(toClone);
	}

	EntryPointDocument(EntryPointBuilder builder){
		super("");
		setName(builder.name);
		setType(builder.type);
		setDefaultEntry(builder.defaultEntry);
		setDomains(builder.domains);
		setStartPage(builder.startPage);
		setStartSite(builder.startSite);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public int getType(){
		return getInt(PROP_TYPE);
	}

	public void setType(int value){
		setInt(PROP_TYPE, value);
	}

	public boolean getDefaultEntry(){
		return getBoolean(PROP_DEFAULT_ENTRY);
	}

	public void setDefaultEntry(boolean value){
		setBoolean(PROP_DEFAULT_ENTRY, value);
	}

	public List<String> getDomains(){
		return copyToStringList(getList(PROP_DOMAINS));
	}

	public void setDomains(List<String> value){
		setList(PROP_DOMAINS, copyFromStringList(value));
	}

	public String getStartPage(){
		return getString(LINK_PROP_START_PAGE);
	}

	public void setStartPage(String value){
		setString(LINK_PROP_START_PAGE, value);
	}

	public String getStartSite(){
		return getString(LINK_PROP_START_SITE);
	}

	public void setStartSite(String value){
		setString(LINK_PROP_START_SITE, value);
	}


	public String toString(){
		String ret = "EntryPoint ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "type: "+getType();
		ret += ", ";
		ret += "defaultEntry: "+getDefaultEntry();
		ret += ", ";
		ret += "domains: "+getDomains();
		return ret;
	}

	public int getDomainsSize(){
		return getList(PROP_DOMAINS).size();
	}

	public void addDomainsElement(String domain){
		getListPropertyAnyCase(PROP_DOMAINS).add(new StringProperty("" + domain, domain));
	} //method

	public void removeDomainsElement(int index){
		getListProperty(PROP_DOMAINS).remove(index);
	} //method

	public void swapDomainsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_DOMAINS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_DOMAINS).get(index2)).getString();
		((StringProperty)getList(PROP_DOMAINS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_DOMAINS).get(index2)).setString(tmp1);
	} //method

	public String getDomainsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_DOMAINS).get(index);
		return p.getString();
	} //method


	public int compareTo(EntryPoint comparable){
		return compareTo(comparable, EntryPointSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		EntryPointDocument anotherDoc = (EntryPointDocument) anotherComparable;
		switch(method){
			case EntryPointSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case EntryPointSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case EntryPointSortType.SORT_BY_TYPE:
				return BasicComparable.compareInt(getType(), anotherDoc.getType());
			case EntryPointSortType.SORT_BY_DEFAULTENTRY:
				return BasicComparable.compareBoolean(getDefaultEntry(), anotherDoc.getDefaultEntry());
			case EntryPointSortType.SORT_BY_STARTPAGE:
				return BasicComparable.compareString(getStartPage(), anotherDoc.getStartPage());
			case EntryPointSortType.SORT_BY_STARTSITE:
				return BasicComparable.compareString(getStartSite(), anotherDoc.getStartSite());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "EntryPoint";
	}

	public String getDefinedParentName(){
		return "ASSiteData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getType());
		footprint.append(getDefaultEntry());
		footprint.append(getDomains());
		footprint.append(getStartPage());
		footprint.append(getStartSite());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof EntryPointDocument) && ((EntryPointDocument)o).getId().equals(getId()));
	}
}
