/**
 ********************************************************************************
 *** BaseRoleDefAction.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asuserdata.action;

import net.anotheria.anosite.gen.shared.action.BaseUserAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asuserdata.data.RoleDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseRoleDefAction extends BaseUserAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Roles";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASUserData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "RoleDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, RoleDef roledef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASUserData.RoleDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASUserData.RoleDef", roledef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockRoleDefs(RoleDef roledef, HttpServletRequest req) throws Exception{
		if(roledef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)roledef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASUserDataService().updateRoleDef( roledef);
			logger.info("Lock-OPERATION, document with id : ["+roledef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockRoleDefs(RoleDef roledef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(roledef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)roledef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASUserDataService().updateRoleDef( roledef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+roledef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+roledef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkRoleDefs(RoleDef roledef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = roledef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)roledef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)roledef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockRoleDefs(roledef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateRoleDefs(RoleDef roledef, HttpServletRequest req) throws Exception{
		if(roledef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)roledef, false, getUserId(req));
		}
		if (isTimeoutReached(roledef)) {
			checkRoleDefs(roledef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(roledef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(RoleDef roledef){
		if (roledef instanceof LockableObject) {
			LockableObject lock = (LockableObject)roledef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(RoleDef roledef, HttpServletRequest req){
		if (roledef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)roledef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
