/**
 ********************************************************************************
 *** BaseUserDefAction.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asuserdata.action;

import net.anotheria.anosite.gen.shared.action.BaseUserAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asuserdata.data.UserDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseUserDefAction extends BaseUserAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Users";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASUserData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "UserDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, UserDef userdef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASUserData.UserDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASUserData.UserDef", userdef, "login");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.login", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASUserData.UserDef", userdef, "status");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.status", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASUserData.UserDef", userdef, "password");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.password", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockUserDefs(UserDef userdef, HttpServletRequest req) throws Exception{
		if(userdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)userdef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASUserDataService().updateUserDef( userdef);
			logger.info("Lock-OPERATION, document with id : ["+userdef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockUserDefs(UserDef userdef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(userdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)userdef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASUserDataService().updateUserDef( userdef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+userdef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+userdef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkUserDefs(UserDef userdef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = userdef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)userdef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)userdef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockUserDefs(userdef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateUserDefs(UserDef userdef, HttpServletRequest req) throws Exception{
		if(userdef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)userdef, false, getUserId(req));
		}
		if (isTimeoutReached(userdef)) {
			checkUserDefs(userdef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(userdef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(UserDef userdef){
		if (userdef instanceof LockableObject) {
			LockableObject lock = (LockableObject)userdef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(UserDef userdef, HttpServletRequest req){
		if (userdef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)userdef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
