/**
 ********************************************************************************
 *** MultiOpDialogRoleDefsAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asuserdata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asuserdata.data.RoleDefFactory;
import net.anotheria.anosite.gen.asuserdata.data.RoleDef;
import net.anotheria.anosite.gen.asuserdata.bean.EditRoleDefFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogRoleDefsAction extends BaseRoleDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asuserdataRoleDefDelete"))
			return asuserdataRoleDefDelete(mapping, req, res);
		if (path.equals("asuserdataRoleDefDuplicate"))
			return asuserdataRoleDefDuplicate(mapping, req, res);
		if (path.equals("asuserdataRoleDefUpdate"))
			return asuserdataRoleDefUpdate(mapping, req, res);
		if (path.equals("asuserdataRoleDefClose"))
			return asuserdataRoleDefClose(mapping, req, res);
		if (path.equals("asuserdataRoleDefLock"))
			return asuserdataRoleDefLock(mapping, req, res);
		if (path.equals("asuserdataRoleDefUnLock"))
			return asuserdataRoleDefUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asuserdataRoleDefDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			RoleDef roledefCurr = getASUserDataService().getRoleDef(id);
			if (roledefCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)roledefCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASUserDataService().deleteRoleDef(id);
		}
		res.sendRedirect("asuserdataRoleDefShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asuserdataRoleDefDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		RoleDef roledefSrc = getASUserDataService().getRoleDef(id);
		RoleDef roledefDest = RoleDefFactory.createRoleDef(roledefSrc);


		RoleDef roledefCreated = getASUserDataService().createRoleDef(roledefDest);
		res.sendRedirect("asuserdataRoleDefEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+roledefCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asuserdataRoleDefUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditRoleDefFB form = new EditRoleDefFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		RoleDef roledef = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		roledef = (RoleDef)getASUserDataService().getRoleDef(form.getId()).clone();
	}else{
		roledef = RoleDefFactory.createRoleDef();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	roledef.setName(form.getName());

	RoleDef updatedCopy = null;
	if (create){
		updatedCopy = getASUserDataService().createRoleDef(roledef);
	}else{
		canUpdateRoleDefs(roledef, req);
		checkRoleDefs(roledef, req);
		updatedCopy = getASUserDataService().updateRoleDef(roledef);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asuserdataRoleDefEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(roledef, req);
		res.sendRedirect("asuserdataRoleDefShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(RoleDef roledef, HttpServletRequest req) throws Exception{
	if(((LockableObject)roledef).isLocked())
		unLockRoleDefs(roledef, req, false);
}

public ActionCommand asuserdataRoleDefLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	RoleDef roledefCurr = id != null && !id.equals("") ? getASUserDataService().getRoleDef(id) : null;
	if(roledefCurr != null && roledefCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)roledefCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockRoleDefs(roledefCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, roledefCurr));
	return null;
}

public ActionCommand asuserdataRoleDefUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	RoleDef roledefCurr = id != null && !id.equals("") ? getASUserDataService().getRoleDef(id) : null;
	if(roledefCurr != null && roledefCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)roledefCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockRoleDefs(roledefCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, roledefCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, RoleDef item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asuserdataRoleDefShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asuserdataRoleDefEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asuserdataRoleDefShow?ts="+System.currentTimeMillis();
}

public ActionCommand asuserdataRoleDefClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	RoleDef roledefCurr = id != null && !id.equals("") ? getASUserDataService().getRoleDef(id) : null;
	if(roledefCurr != null && roledefCurr instanceof LockableObject && ((LockableObject)roledefCurr).isLocked()) 
		unLockRoleDefs(roledefCurr, req, false);
	res.sendRedirect("asuserdataRoleDefShow?ts="+System.currentTimeMillis());
	return null;
}

}
