/**
 ********************************************************************************
 *** MultiOpDialogUserDefsAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asuserdata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asuserdata.data.UserDefFactory;
import net.anotheria.anosite.gen.asuserdata.data.UserDef;
import net.anotheria.anosite.gen.asuserdata.bean.EditUserDefFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogUserDefsAction extends BaseUserDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asuserdataUserDefDelete"))
			return asuserdataUserDefDelete(mapping, req, res);
		if (path.equals("asuserdataUserDefDuplicate"))
			return asuserdataUserDefDuplicate(mapping, req, res);
		if (path.equals("asuserdataUserDefUpdate"))
			return asuserdataUserDefUpdate(mapping, req, res);
		if (path.equals("asuserdataUserDefClose"))
			return asuserdataUserDefClose(mapping, req, res);
		if (path.equals("asuserdataUserDefLock"))
			return asuserdataUserDefLock(mapping, req, res);
		if (path.equals("asuserdataUserDefUnLock"))
			return asuserdataUserDefUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asuserdataUserDefDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			UserDef userdefCurr = getASUserDataService().getUserDef(id);
			if (userdefCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)userdefCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASUserDataService().deleteUserDef(id);
		}
		res.sendRedirect("asuserdataUserDefShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asuserdataUserDefDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		UserDef userdefSrc = getASUserDataService().getUserDef(id);
		UserDef userdefDest = UserDefFactory.createUserDef(userdefSrc);



		UserDef userdefCreated = getASUserDataService().createUserDef(userdefDest);
		res.sendRedirect("asuserdataUserDefEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+userdefCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asuserdataUserDefUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditUserDefFB form = new EditUserDefFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		UserDef userdef = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		userdef = (UserDef)getASUserDataService().getUserDef(form.getId()).clone();
	}else{
		userdef = UserDefFactory.createUserDef();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	userdef.setLogin(form.getLogin());
	// skipped container status
	userdef.setPassword(form.getPassword());

	UserDef updatedCopy = null;
	if (create){
		updatedCopy = getASUserDataService().createUserDef(userdef);
	}else{
		canUpdateUserDefs(userdef, req);
		checkUserDefs(userdef, req);
		updatedCopy = getASUserDataService().updateUserDef(userdef);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asuserdataUserDefEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(userdef, req);
		res.sendRedirect("asuserdataUserDefShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(UserDef userdef, HttpServletRequest req) throws Exception{
	if(((LockableObject)userdef).isLocked())
		unLockUserDefs(userdef, req, false);
}

public ActionCommand asuserdataUserDefLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	UserDef userdefCurr = id != null && !id.equals("") ? getASUserDataService().getUserDef(id) : null;
	if(userdefCurr != null && userdefCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)userdefCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockUserDefs(userdefCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, userdefCurr));
	return null;
}

public ActionCommand asuserdataUserDefUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	UserDef userdefCurr = id != null && !id.equals("") ? getASUserDataService().getUserDef(id) : null;
	if(userdefCurr != null && userdefCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)userdefCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockUserDefs(userdefCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, userdefCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, UserDef item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asuserdataUserDefShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asuserdataUserDefEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asuserdataUserDefShow?ts="+System.currentTimeMillis();
}

public ActionCommand asuserdataUserDefClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	UserDef userdefCurr = id != null && !id.equals("") ? getASUserDataService().getUserDef(id) : null;
	if(userdefCurr != null && userdefCurr instanceof LockableObject && ((LockableObject)userdefCurr).isLocked()) 
		unLockUserDefs(userdefCurr, req, false);
	res.sendRedirect("asuserdataUserDefShow?ts="+System.currentTimeMillis());
	return null;
}

}
