/**
 ********************************************************************************
 *** MultiOpBoxsGuardsAction.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.BoxFactory;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.bean.GuardsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.GuardsQuickAddFB;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDefSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBoxsGuardsAction extends BaseBoxAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataBoxGuardsShow"))
			return aswebdataBoxGuardsShow(mapping, req, res);
		if (path.equals("aswebdataBoxGuardsAdd"))
			return aswebdataBoxGuardsAdd(mapping, req, res);
		if (path.equals("aswebdataBoxGuardsDelete"))
			return aswebdataBoxGuardsDelete(mapping, req, res);
		if (path.equals("aswebdataBoxGuardsMove"))
			return aswebdataBoxGuardsMove(mapping, req, res);
		if (path.equals("aswebdataBoxGuardsQuickAdd"))
			return aswebdataBoxGuardsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataBoxGuardsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box box = getASWebDataService().getBox(id);
		addBeanToRequest(req, "ownerId", id);
		checkBoxs(box, req);

		GuardsElementFB form = new GuardsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxGuardsElementForm", form);

		GuardsQuickAddFB quickAddForm = new GuardsQuickAddFB() ;
		quickAddForm.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxGuardsQuickAddForm", quickAddForm);


		//link guard to ASFederatedData.GuardDef
		List<GuardDef> guarddefs = getASFederatedDataService().getGuardDefs(new GuardDefSortType(GuardDefSortType.SORT_BY_NAME));
		List<LabelValueBean> guarddefsValues = new ArrayList<LabelValueBean>(guarddefs.size());
		for (int i=0; i<guarddefs.size(); i++){
			net.anotheria.anosite.gen.asfederateddata.data.GuardDef tmp_guarddef = (net.anotheria.anosite.gen.asfederateddata.data.GuardDef) guarddefs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_guarddef.getId(), tmp_guarddef.getName()+" ["+tmp_guarddef.getId()+"]" );
			guarddefsValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", guarddefsValues);
		// generate list ...
		int size = box.getGuardsSize();
		List<GuardsElementFB> beans = new ArrayList<GuardsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = box.getGuardsElement(i);
			GuardsElementFB bean = new GuardsElementFB();
			bean.setOwnerId(box.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				GuardDef tmp_guarddef = getASFederatedDataService().getGuardDef(value);
				bean.setDescription(tmp_guarddef.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataBoxGuardsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box boxCurr = getASWebDataService().getBox(id);
		canUpdateBoxs(boxCurr, req);
		checkBoxs(boxCurr, req);
		int position = getIntParameter(req, "pPosition");
		Box box = getASWebDataService().getBox(id);
		box.removeGuardsElement(position);
		getASWebDataService().updateBox(box);
		return aswebdataBoxGuardsShow(mapping, req, res);
	}

	public ActionCommand aswebdataBoxGuardsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Box box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(box, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(box, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(box, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(box, position);
		return aswebdataBoxGuardsShow(mapping, req, res);
	}

	private void moveUp(Box box, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		box.swapGuardsElement(position, position-1);
		getASWebDataService().updateBox(box);
	}

	private void moveTop(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		box.setGuards(targetList);
		getASWebDataService().updateBox(box);
	}

	private void moveDown(Box box, int position) throws ASGRuntimeException {
		if (position<box.getGuardsSize()-1){
			box.swapGuardsElement(position, position+1);
			getASWebDataService().updateBox(box);
		}
	}

	private void moveBottom(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		box.setGuards(targetList);
		getASWebDataService().updateBox(box);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataBoxGuardsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsElementFB form = new GuardsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		box.addGuardsElement(form.getGuard());
		getASWebDataService().updateBox(box);
		return aswebdataBoxGuardsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataBoxGuardsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsQuickAddFB form = new GuardsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				box.addGuardsElement(""+i);
			}
		}
		getASWebDataService().updateBox(box);
		return aswebdataBoxGuardsShow(mapping, req, res);
	}

}
