/**
 ********************************************************************************
 *** MultiOpBoxsScriptsAction.java                                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.BoxFactory;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.bean.ScriptsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.ScriptsQuickAddFB;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.anosite.gen.assitedata.data.ScriptSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBoxsScriptsAction extends BaseBoxAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataBoxScriptsShow"))
			return aswebdataBoxScriptsShow(mapping, req, res);
		if (path.equals("aswebdataBoxScriptsAdd"))
			return aswebdataBoxScriptsAdd(mapping, req, res);
		if (path.equals("aswebdataBoxScriptsDelete"))
			return aswebdataBoxScriptsDelete(mapping, req, res);
		if (path.equals("aswebdataBoxScriptsMove"))
			return aswebdataBoxScriptsMove(mapping, req, res);
		if (path.equals("aswebdataBoxScriptsQuickAdd"))
			return aswebdataBoxScriptsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataBoxScriptsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box box = getASWebDataService().getBox(id);
		addBeanToRequest(req, "ownerId", id);
		checkBoxs(box, req);

		ScriptsElementFB form = new ScriptsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxScriptsElementForm", form);

		ScriptsQuickAddFB quickAddForm = new ScriptsQuickAddFB() ;
		quickAddForm.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxScriptsQuickAddForm", quickAddForm);


		//link script to ASSiteData.Script
		List<Script> scripts = getASSiteDataService().getScripts(new ScriptSortType(ScriptSortType.SORT_BY_NAME));
		List<LabelValueBean> scriptsValues = new ArrayList<LabelValueBean>(scripts.size());
		for (int i=0; i<scripts.size(); i++){
			net.anotheria.anosite.gen.assitedata.data.Script tmp_script = (net.anotheria.anosite.gen.assitedata.data.Script) scripts.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_script.getId(), tmp_script.getName()+" ["+tmp_script.getId()+"]" );
			scriptsValues.add(bean);
		}
		addBeanToRequest(req, "scriptValuesCollection", scriptsValues);
		// generate list ...
		int size = box.getScriptsSize();
		List<ScriptsElementFB> beans = new ArrayList<ScriptsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = box.getScriptsElement(i);
			ScriptsElementFB bean = new ScriptsElementFB();
			bean.setOwnerId(box.getId());
			bean.setPosition(i);
			bean.setScript(value);
			try{
				Script tmp_script = getASSiteDataService().getScript(value);
				bean.setDescription(tmp_script.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataBoxScriptsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box boxCurr = getASWebDataService().getBox(id);
		canUpdateBoxs(boxCurr, req);
		checkBoxs(boxCurr, req);
		int position = getIntParameter(req, "pPosition");
		Box box = getASWebDataService().getBox(id);
		box.removeScriptsElement(position);
		getASWebDataService().updateBox(box);
		return aswebdataBoxScriptsShow(mapping, req, res);
	}

	public ActionCommand aswebdataBoxScriptsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Box box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(box, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(box, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(box, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(box, position);
		return aswebdataBoxScriptsShow(mapping, req, res);
	}

	private void moveUp(Box box, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		box.swapScriptsElement(position, position-1);
		getASWebDataService().updateBox(box);
	}

	private void moveTop(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getScripts();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		box.setScripts(targetList);
		getASWebDataService().updateBox(box);
	}

	private void moveDown(Box box, int position) throws ASGRuntimeException {
		if (position<box.getScriptsSize()-1){
			box.swapScriptsElement(position, position+1);
			getASWebDataService().updateBox(box);
		}
	}

	private void moveBottom(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getScripts();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		box.setScripts(targetList);
		getASWebDataService().updateBox(box);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataBoxScriptsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ScriptsElementFB form = new ScriptsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		box.addScriptsElement(form.getScript());
		getASWebDataService().updateBox(box);
		return aswebdataBoxScriptsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataBoxScriptsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ScriptsQuickAddFB form = new ScriptsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				box.addScriptsElement(""+i);
			}
		}
		getASWebDataService().updateBox(box);
		return aswebdataBoxScriptsShow(mapping, req, res);
	}

}
