/**
 ********************************************************************************
 *** ShowBoxsAction.java                                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.bean.BoxListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.aswebdata.bean.BoxListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowBoxsAction extends BaseBoxAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Box";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Box";
	private static Logger log = LoggerFactory.getLogger(ShowBoxsAction.class);
	private Sorter<BoxListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator typeDecorator;
	private IAttributeDecorator handlerDecorator;
	private IAttributeDecorator mediaLinksDecorator;
	private IAttributeDecorator scriptsDecorator;
	private IAttributeDecorator localizationsDecorator;
	private IAttributeDecorator subboxesDecorator;
	private IAttributeDecorator guardsDecorator;
	private IAttributeDecorator attributesDecorator;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ShowBoxsAction(){
		sorter = new QuickSorter<BoxListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			typeDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
			handlerDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
			mediaLinksDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.MediaLinksListCMS2Decorator").newInstance();
			scriptsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.ScriptsListCMS2Decorator").newInstance();
			localizationsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LocalizationsListCMS2Decorator").newInstance();
			subboxesDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			guardsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.GuardCMS2Decorator").newInstance();
			attributesDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.AttributeCMS2Decorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = BoxListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = BoxListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		BoxListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new BoxListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (BoxListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new BoxListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<Box> _unfiltered_boxs = getASWebDataService().getBoxs();
		List<Box> boxs = new ArrayList<Box>();
		for (int i=0; i<_unfiltered_boxs.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_boxs.get(i), "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass(_unfiltered_boxs.get(i), "Any", filterParameter1));
			if (mayPass)
				boxs.add(_unfiltered_boxs.get(i));
		}
		List<BoxListItemBean> beans = new ArrayList<BoxListItemBean>(boxs.size());
		for (Box box : boxs){
			checkBoxs(box, req);
			BoxListItemBean bean = makeBoxListItemBean(box);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "boxs", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer("Any"));
		return mapping.success();
	}

	protected BoxListItemBean makeBoxListItemBean(Box box) {
		BoxListItemBean bean = new BoxListItemBean();
		bean.setPlainId(box.getId());
		bean.setIdForSorting(box.getId());
		bean.setId(idDecorator.decorate(box, "id", "3"));
		bean.setNameForSorting(box.getName());
		bean.setName(nameDecorator.decorate(box, "name", "null"));
		bean.setTypeForSorting(box.getType());
		bean.setType(typeDecorator.decorate(box, "type", "null"));
		bean.setHandlerForSorting(box.getHandler());
		bean.setHandler(handlerDecorator.decorate(box, "handler", "null"));
		bean.setCssClass(box.getCssClass());
		bean.setMediaLinksForSorting(box.getMediaLinks());
		bean.setMediaLinks(mediaLinksDecorator.decorate(box, "mediaLinks", "null"));
		bean.setScriptsForSorting(box.getScripts());
		bean.setScripts(scriptsDecorator.decorate(box, "scripts", "null"));
		bean.setLocalizationsForSorting(box.getLocalizations());
		bean.setLocalizations(localizationsDecorator.decorate(box, "localizations", "null"));
		bean.setSubboxesForSorting(box.getSubboxes());
		bean.setSubboxes(subboxesDecorator.decorate(box, "subboxes", "null"));
		bean.setGuardsForSorting(box.getGuards());
		bean.setGuards(guardsDecorator.decorate(box, "guards", "null"));
		bean.setAttributesForSorting(box.getAttributes());
		bean.setAttributes(attributesDecorator.decorate(box, "attributes", "null"));
		bean.setFeature(box.getFeature());
		bean.setLocked(((LockableObject)box).isLocked());
		bean.setLockerId(((LockableObject)box).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)box).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)box).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(box.getLastUpdateTimestamp()));
		return bean;
	}
}
