/**
 ********************************************************************************
 *** TransferPagexAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import java.util.HashSet;
import java.io.IOException;
import java.io.PrintWriter;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.config.DocumentTransferConfig;
import org.configureme.ConfigurationManager;
import org.json.JSONException;
import net.anotheria.maf.json.JSONResponse;
import org.codehaus.jettison.json.JSONArray;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.anotheria.anosite.util.staticutil.JerseyClientUtil;

public class TransferPagexAction extends BasePagexAction{


	private static final int STATUS_OK = 201;
	private static final String ERROR = "error";

	private DocumentTransferConfig config = DocumentTransferConfig.getInstance();

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateTransferActionMethod

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{

		JSONResponse response = new JSONResponse();
		if (ConfigurationManager.INSTANCE.getDefaultEnvironment().expandedStringForm().equals("prod")) {
			response.addError(ERROR, "Environment is prod");
			writeTextToResponse(res, response);
			return null;
		}

		String id = getStringParameter(req, PARAM_ID);
		JSONArray data = new JSONArray();
		try {
			getASWebDataService().fetchPagex(id, new HashSet<String>(), data);
		}catch(ASWebDataServiceException e){
			response.addError(ERROR, "Problem occurred when fetching info about documents -" + e.getMessage());
			writeTextToResponse(res, response);
			return null;
		}

		Client client = JerseyClientUtil.getClientInstance();
		for (String domain :config.getDomains()) {
			Response clientResponse = client.target(domain + "/api/pagex")
			 		.request(MediaType.APPLICATION_JSON)
			 		.post(Entity.entity(data.toString(), MediaType.APPLICATION_JSON));

			if (clientResponse.getStatus() != STATUS_OK) {
				clientResponse.close();
				response.addError(ERROR, "Couldn't save transferred objects, status expected 201, got status - " + clientResponse.getStatus());
				writeTextToResponse(res, response);
			}

			clientResponse.close();
		}
		return null;
	}

	private void writeTextToResponse(final HttpServletResponse res, final JSONResponse jsonResponse) throws IOException, JSONException {
		res.setCharacterEncoding("UTF-8");
		res.setContentType("application/json");
		PrintWriter writer = res.getWriter();
		writer.write(jsonResponse.toString());
		writer.flush();
	}
}
