/**
 ********************************************************************************
 *** BoxDocument.java                                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;
import net.anotheria.asg.data.MultilingualObject;

public class BoxDocument extends AbstractASGDocument implements Box, IComparable, MultilingualObject{

	public BoxDocument() {
		super("");
	}

	public BoxDocument(String id){
		super(id);
	}

	public BoxDocument(BoxDocument toClone){
		super(toClone);
	}

	BoxDocument(BoxBuilder builder){
		super("");
		setName(builder.name);
		setContent(builder.content);
		setMediaLinks(builder.mediaLinks);
		setScripts(builder.scripts);
		setLocalizations(builder.localizations);
		setSubboxes(builder.subboxes);
		setCssClass(builder.cssClass);
		setParameter1(builder.parameter1);
		setParameter2(builder.parameter2);
		setParameter3(builder.parameter3);
		setParameter4(builder.parameter4);
		setParameter5(builder.parameter5);
		setParameter6(builder.parameter6);
		setParameter7(builder.parameter7);
		setParameter8(builder.parameter8);
		setParameter9(builder.parameter9);
		setParameter10(builder.parameter10);
		setGuards(builder.guards);
		setAttributes(builder.attributes);
		setType(builder.type);
		setHandler(builder.handler);
		setAccessOperation(builder.accessOperation);
		setFeature(builder.feature);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getContentEN(){
		return getString(PROP_CONTENT_EN);
	}

	public String getContent(){
		return getString("content_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setContentEN(String value){
		setString(PROP_CONTENT_EN, value);
	}

	public void setContent(String value){
		setString(("content_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public List<String> getMediaLinks(){
		return copyToStringList(getList(PROP_MEDIA_LINKS));
	}

	public void setMediaLinks(List<String> value){
		setList(PROP_MEDIA_LINKS, copyFromStringList(value));
	}

	public List<String> getScripts(){
		return copyToStringList(getList(PROP_SCRIPTS));
	}

	public void setScripts(List<String> value){
		setList(PROP_SCRIPTS, copyFromStringList(value));
	}

	public List<String> getLocalizations(){
		return copyToStringList(getList(PROP_LOCALIZATIONS));
	}

	public void setLocalizations(List<String> value){
		setList(PROP_LOCALIZATIONS, copyFromStringList(value));
	}

	public List<String> getSubboxes(){
		return copyToStringList(getList(PROP_SUBBOXES));
	}

	public void setSubboxes(List<String> value){
		setList(PROP_SUBBOXES, copyFromStringList(value));
	}

	public String getCssClass(){
		return getString(PROP_CSS_CLASS);
	}

	public void setCssClass(String value){
		setString(PROP_CSS_CLASS, value);
	}

	public String getParameter1(){
		return getString(PROP_PARAMETER1);
	}

	public void setParameter1(String value){
		setString(PROP_PARAMETER1, value);
	}

	public String getParameter2(){
		return getString(PROP_PARAMETER2);
	}

	public void setParameter2(String value){
		setString(PROP_PARAMETER2, value);
	}

	public String getParameter3(){
		return getString(PROP_PARAMETER3);
	}

	public void setParameter3(String value){
		setString(PROP_PARAMETER3, value);
	}

	public String getParameter4(){
		return getString(PROP_PARAMETER4);
	}

	public void setParameter4(String value){
		setString(PROP_PARAMETER4, value);
	}

	public String getParameter5(){
		return getString(PROP_PARAMETER5);
	}

	public void setParameter5(String value){
		setString(PROP_PARAMETER5, value);
	}

	public String getParameter6(){
		return getString(PROP_PARAMETER6);
	}

	public void setParameter6(String value){
		setString(PROP_PARAMETER6, value);
	}

	public String getParameter7(){
		return getString(PROP_PARAMETER7);
	}

	public void setParameter7(String value){
		setString(PROP_PARAMETER7, value);
	}

	public String getParameter8(){
		return getString(PROP_PARAMETER8);
	}

	public void setParameter8(String value){
		setString(PROP_PARAMETER8, value);
	}

	public String getParameter9(){
		return getString(PROP_PARAMETER9);
	}

	public void setParameter9(String value){
		setString(PROP_PARAMETER9, value);
	}

	public String getParameter10(){
		return getString(PROP_PARAMETER10);
	}

	public void setParameter10(String value){
		setString(PROP_PARAMETER10, value);
	}

	public List<String> getGuards(){
		return copyToStringList(getList(PROP_GUARDS));
	}

	public void setGuards(List<String> value){
		setList(PROP_GUARDS, copyFromStringList(value));
	}

	public List<String> getAttributes(){
		return copyToStringList(getList(PROP_ATTRIBUTES));
	}

	public void setAttributes(List<String> value){
		setList(PROP_ATTRIBUTES, copyFromStringList(value));
	}

	public String getType(){
		return getString(LINK_PROP_TYPE);
	}

	public void setType(String value){
		setString(LINK_PROP_TYPE, value);
	}

	public String getHandler(){
		return getString(LINK_PROP_HANDLER);
	}

	public void setHandler(String value){
		setString(LINK_PROP_HANDLER, value);
	}

	public String getAccessOperation(){
		return getString(LINK_PROP_ACCESS_OPERATION);
	}

	public void setAccessOperation(String value){
		setString(LINK_PROP_ACCESS_OPERATION, value);
	}

	public String getFeature(){
		return getString(LINK_PROP_FEATURE);
	}

	public void setFeature(String value){
		setString(LINK_PROP_FEATURE, value);
	}


	public String toString(){
		String ret = "Box ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "content: "+getContent();
		ret += ", ";
		ret += "mediaLinks: "+getMediaLinks();
		ret += ", ";
		ret += "scripts: "+getScripts();
		ret += ", ";
		ret += "localizations: "+getLocalizations();
		ret += ", ";
		ret += "subboxes: "+getSubboxes();
		ret += ", ";
		ret += "cssClass: "+getCssClass();
		ret += ", ";
		ret += "parameter1: "+getParameter1();
		ret += ", ";
		ret += "parameter2: "+getParameter2();
		ret += ", ";
		ret += "parameter3: "+getParameter3();
		ret += ", ";
		ret += "parameter4: "+getParameter4();
		ret += ", ";
		ret += "parameter5: "+getParameter5();
		ret += ", ";
		ret += "parameter6: "+getParameter6();
		ret += ", ";
		ret += "parameter7: "+getParameter7();
		ret += ", ";
		ret += "parameter8: "+getParameter8();
		ret += ", ";
		ret += "parameter9: "+getParameter9();
		ret += ", ";
		ret += "parameter10: "+getParameter10();
		ret += ", ";
		ret += "guards: "+getGuards();
		ret += ", ";
		ret += "attributes: "+getAttributes();
		return ret;
	}

	public int getMediaLinksSize(){
		return getList(PROP_MEDIA_LINKS).size();
	}

	public void addMediaLinksElement(String mediaLink){
		getListPropertyAnyCase(PROP_MEDIA_LINKS).add(new StringProperty("" + mediaLink, mediaLink));
	} //method

	public void removeMediaLinksElement(int index){
		getListProperty(PROP_MEDIA_LINKS).remove(index);
	} //method

	public void swapMediaLinksElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_MEDIA_LINKS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_MEDIA_LINKS).get(index2)).getString();
		((StringProperty)getList(PROP_MEDIA_LINKS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_MEDIA_LINKS).get(index2)).setString(tmp1);
	} //method

	public String getMediaLinksElement(int index){
		StringProperty p = (StringProperty)getList(PROP_MEDIA_LINKS).get(index);
		return p.getString();
	} //method

	public int getScriptsSize(){
		return getList(PROP_SCRIPTS).size();
	}

	public void addScriptsElement(String script){
		getListPropertyAnyCase(PROP_SCRIPTS).add(new StringProperty("" + script, script));
	} //method

	public void removeScriptsElement(int index){
		getListProperty(PROP_SCRIPTS).remove(index);
	} //method

	public void swapScriptsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_SCRIPTS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_SCRIPTS).get(index2)).getString();
		((StringProperty)getList(PROP_SCRIPTS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_SCRIPTS).get(index2)).setString(tmp1);
	} //method

	public String getScriptsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_SCRIPTS).get(index);
		return p.getString();
	} //method

	public int getLocalizationsSize(){
		return getList(PROP_LOCALIZATIONS).size();
	}

	public void addLocalizationsElement(String localization){
		getListPropertyAnyCase(PROP_LOCALIZATIONS).add(new StringProperty("" + localization, localization));
	} //method

	public void removeLocalizationsElement(int index){
		getListProperty(PROP_LOCALIZATIONS).remove(index);
	} //method

	public void swapLocalizationsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_LOCALIZATIONS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_LOCALIZATIONS).get(index2)).getString();
		((StringProperty)getList(PROP_LOCALIZATIONS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_LOCALIZATIONS).get(index2)).setString(tmp1);
	} //method

	public String getLocalizationsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_LOCALIZATIONS).get(index);
		return p.getString();
	} //method

	public int getSubboxesSize(){
		return getList(PROP_SUBBOXES).size();
	}

	public void addSubboxesElement(String subbox){
		getListPropertyAnyCase(PROP_SUBBOXES).add(new StringProperty("" + subbox, subbox));
	} //method

	public void removeSubboxesElement(int index){
		getListProperty(PROP_SUBBOXES).remove(index);
	} //method

	public void swapSubboxesElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_SUBBOXES).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_SUBBOXES).get(index2)).getString();
		((StringProperty)getList(PROP_SUBBOXES).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_SUBBOXES).get(index2)).setString(tmp1);
	} //method

	public String getSubboxesElement(int index){
		StringProperty p = (StringProperty)getList(PROP_SUBBOXES).get(index);
		return p.getString();
	} //method

	public int getGuardsSize(){
		return getList(PROP_GUARDS).size();
	}

	public void addGuardsElement(String guard){
		getListPropertyAnyCase(PROP_GUARDS).add(new StringProperty("" + guard, guard));
	} //method

	public void removeGuardsElement(int index){
		getListProperty(PROP_GUARDS).remove(index);
	} //method

	public void swapGuardsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_GUARDS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_GUARDS).get(index2)).getString();
		((StringProperty)getList(PROP_GUARDS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_GUARDS).get(index2)).setString(tmp1);
	} //method

	public String getGuardsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_GUARDS).get(index);
		return p.getString();
	} //method

	public int getAttributesSize(){
		return getList(PROP_ATTRIBUTES).size();
	}

	public void addAttributesElement(String attribute){
		getListPropertyAnyCase(PROP_ATTRIBUTES).add(new StringProperty("" + attribute, attribute));
	} //method

	public void removeAttributesElement(int index){
		getListProperty(PROP_ATTRIBUTES).remove(index);
	} //method

	public void swapAttributesElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_ATTRIBUTES).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_ATTRIBUTES).get(index2)).getString();
		((StringProperty)getList(PROP_ATTRIBUTES).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_ATTRIBUTES).get(index2)).setString(tmp1);
	} //method

	public String getAttributesElement(int index){
		StringProperty p = (StringProperty)getList(PROP_ATTRIBUTES).get(index);
		return p.getString();
	} //method


	public int compareTo(Box comparable){
		return compareTo(comparable, BoxSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		BoxDocument anotherDoc = (BoxDocument) anotherComparable;
		switch(method){
			case BoxSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case BoxSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case BoxSortType.SORT_BY_CONTENT:
				return BasicComparable.compareString(getContent(), anotherDoc.getContent());
			case BoxSortType.SORT_BY_CSSCLASS:
				return BasicComparable.compareString(getCssClass(), anotherDoc.getCssClass());
			case BoxSortType.SORT_BY_PARAMETER1:
				return BasicComparable.compareString(getParameter1(), anotherDoc.getParameter1());
			case BoxSortType.SORT_BY_PARAMETER2:
				return BasicComparable.compareString(getParameter2(), anotherDoc.getParameter2());
			case BoxSortType.SORT_BY_PARAMETER3:
				return BasicComparable.compareString(getParameter3(), anotherDoc.getParameter3());
			case BoxSortType.SORT_BY_PARAMETER4:
				return BasicComparable.compareString(getParameter4(), anotherDoc.getParameter4());
			case BoxSortType.SORT_BY_PARAMETER5:
				return BasicComparable.compareString(getParameter5(), anotherDoc.getParameter5());
			case BoxSortType.SORT_BY_PARAMETER6:
				return BasicComparable.compareString(getParameter6(), anotherDoc.getParameter6());
			case BoxSortType.SORT_BY_PARAMETER7:
				return BasicComparable.compareString(getParameter7(), anotherDoc.getParameter7());
			case BoxSortType.SORT_BY_PARAMETER8:
				return BasicComparable.compareString(getParameter8(), anotherDoc.getParameter8());
			case BoxSortType.SORT_BY_PARAMETER9:
				return BasicComparable.compareString(getParameter9(), anotherDoc.getParameter9());
			case BoxSortType.SORT_BY_PARAMETER10:
				return BasicComparable.compareString(getParameter10(), anotherDoc.getParameter10());
			case BoxSortType.SORT_BY_TYPE:
				return BasicComparable.compareString(getType(), anotherDoc.getType());
			case BoxSortType.SORT_BY_HANDLER:
				return BasicComparable.compareString(getHandler(), anotherDoc.getHandler());
			case BoxSortType.SORT_BY_ACCESSOPERATION:
				return BasicComparable.compareString(getAccessOperation(), anotherDoc.getAccessOperation());
			case BoxSortType.SORT_BY_FEATURE:
				return BasicComparable.compareString(getFeature(), anotherDoc.getFeature());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Box";
	}

	public String getDefinedParentName(){
		return "ASWebData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getContentEN());
		footprint.append(getMediaLinks());
		footprint.append(getScripts());
		footprint.append(getLocalizations());
		footprint.append(getSubboxes());
		footprint.append(getCssClass());
		footprint.append(getParameter1());
		footprint.append(getParameter2());
		footprint.append(getParameter3());
		footprint.append(getParameter4());
		footprint.append(getParameter5());
		footprint.append(getParameter6());
		footprint.append(getParameter7());
		footprint.append(getParameter8());
		footprint.append(getParameter9());
		footprint.append(getParameter10());
		footprint.append(getGuards());
		footprint.append(getAttributes());
		footprint.append(getType());
		footprint.append(getHandler());
		footprint.append(getAccessOperation());
		footprint.append(getFeature());
		return MD5Util.getMD5Hash(footprint);
	}
	public void copyLANG2LANG(String sourceLanguage, String destLanguage){
	}


	public boolean isMultilingualDisabledInstance(){
		try{
			return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean();
		}catch(NoSuchPropertyException e){
			return false;
		}
	}

	public void setMultilingualDisabledInstance(boolean value){
		setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value));
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof BoxDocument) && ((BoxDocument)o).getId().equals(getId()));
	}
}
