/**
 ********************************************************************************
 *** ShowWizardDefsAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswizarddata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.anosite.gen.aswizarddata.bean.WizardDefListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.aswizarddata.bean.WizardDefListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowWizardDefsAction extends BaseWizardDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"WizardDef";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"WizardDef";
	private static Logger log = LoggerFactory.getLogger(ShowWizardDefsAction.class);
	private Sorter<WizardDefListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowWizardDefsAction(){
		sorter = new QuickSorter<WizardDefListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = WizardDefListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = WizardDefListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		WizardDefListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new WizardDefListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (WizardDefListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new WizardDefListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<WizardDef> _unfiltered_wizarddefs = getASWizardDataService().getWizardDefs();
		List<WizardDef> wizarddefs = new ArrayList<WizardDef>();
		for (int i=0; i<_unfiltered_wizarddefs.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_wizarddefs.get(i), "name", filterParameter0));
			if (mayPass)
				wizarddefs.add(_unfiltered_wizarddefs.get(i));
		}
		List<WizardDefListItemBean> beans = new ArrayList<WizardDefListItemBean>(wizarddefs.size());
		for (WizardDef wizarddef : wizarddefs){
			checkWizardDefs(wizarddef, req);
			WizardDefListItemBean bean = makeWizardDefListItemBean(wizarddef);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "wizarddefs", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected WizardDefListItemBean makeWizardDefListItemBean(WizardDef wizarddef) {
		WizardDefListItemBean bean = new WizardDefListItemBean();
		bean.setPlainId(wizarddef.getId());
		bean.setIdForSorting(wizarddef.getId());
		bean.setId(idDecorator.decorate(wizarddef, "id", "3"));
		bean.setNameForSorting(wizarddef.getName());
		bean.setName(nameDecorator.decorate(wizarddef, "name", "null"));
		bean.setWizardSteps(wizarddef.getWizardSteps());
		bean.setHandler(wizarddef.getHandler());
		bean.setWizardCancelRedirectUrl(wizarddef.getWizardCancelRedirectUrl());
		bean.setWizardFinishRedirectUrl(wizarddef.getWizardFinishRedirectUrl());
		bean.setLocked(((LockableObject)wizarddef).isLocked());
		bean.setLockerId(((LockableObject)wizarddef).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)wizarddef).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)wizarddef).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(wizarddef.getLastUpdateTimestamp()));
		return bean;
	}
}
