/**
 ********************************************************************************
 *** ShowWizardHandlerDefsAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswizarddata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswizarddata.data.WizardHandlerDef;
import net.anotheria.anosite.gen.aswizarddata.bean.WizardHandlerDefListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.aswizarddata.bean.WizardHandlerDefListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowWizardHandlerDefsAction extends BaseWizardHandlerDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"WizardHandlerDef";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"WizardHandlerDef";
	private static Logger log = LoggerFactory.getLogger(ShowWizardHandlerDefsAction.class);
	private Sorter<WizardHandlerDefListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowWizardHandlerDefsAction(){
		sorter = new QuickSorter<WizardHandlerDefListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = WizardHandlerDefListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = WizardHandlerDefListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		WizardHandlerDefListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new WizardHandlerDefListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (WizardHandlerDefListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new WizardHandlerDefListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<WizardHandlerDef> _unfiltered_wizardhandlerdefs = getASWizardDataService().getWizardHandlerDefs();
		List<WizardHandlerDef> wizardhandlerdefs = new ArrayList<WizardHandlerDef>();
		for (int i=0; i<_unfiltered_wizardhandlerdefs.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_wizardhandlerdefs.get(i), "name", filterParameter0));
			if (mayPass)
				wizardhandlerdefs.add(_unfiltered_wizardhandlerdefs.get(i));
		}
		List<WizardHandlerDefListItemBean> beans = new ArrayList<WizardHandlerDefListItemBean>(wizardhandlerdefs.size());
		for (WizardHandlerDef wizardhandlerdef : wizardhandlerdefs){
			checkWizardHandlerDefs(wizardhandlerdef, req);
			WizardHandlerDefListItemBean bean = makeWizardHandlerDefListItemBean(wizardhandlerdef);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "wizardhandlerdefs", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected WizardHandlerDefListItemBean makeWizardHandlerDefListItemBean(WizardHandlerDef wizardhandlerdef) {
		WizardHandlerDefListItemBean bean = new WizardHandlerDefListItemBean();
		bean.setPlainId(wizardhandlerdef.getId());
		bean.setIdForSorting(wizardhandlerdef.getId());
		bean.setId(idDecorator.decorate(wizardhandlerdef, "id", "3"));
		bean.setNameForSorting(wizardhandlerdef.getName());
		bean.setName(nameDecorator.decorate(wizardhandlerdef, "name", "null"));
		bean.setClazz(wizardhandlerdef.getClazz());
		bean.setLocked(((LockableObject)wizardhandlerdef).isLocked());
		bean.setLockerId(((LockableObject)wizardhandlerdef).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)wizardhandlerdef).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)wizardhandlerdef).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(wizardhandlerdef.getLastUpdateTimestamp()));
		return bean;
	}
}
