/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class RectangleUtilies {
    public static Rectangle2D toRelativRectangle(Dimension dimension, Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        double withRelation = 100.0 / dimension.getWidth();
        double heightRelation = 100.0 / dimension.getHeight();
        double x = withRelation * rectangle.getX();
        double width = withRelation * rectangle.getWidth();
        double y = heightRelation * rectangle.getY();
        double height = heightRelation * rectangle.getHeight();
        return new Rectangle2D.Double(x, y, width, height);
    }

    public static Rectangle toAbsoluteRectangle(Dimension dimension, Rectangle2D rectangle) {
        if (rectangle == null) {
            return null;
        }
        int x = (int)Math.round(dimension.getWidth() * (rectangle.getX() / 100.0));
        int width = (int)Math.round(dimension.getWidth() * (rectangle.getWidth() / 100.0));
        int y = (int)Math.round(dimension.getHeight() * (rectangle.getY() / 100.0));
        int height = (int)Math.round(dimension.getHeight() * (rectangle.getHeight() / 100.0));
        return new Rectangle(x, y, width, height);
    }
}

