/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.date;

import java.text.SimpleDateFormat;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public final class DateStringValidator
implements IValidator<String> {
    private final SimpleDateFormat format;

    public DateStringValidator(SimpleDateFormat format) {
        this.format = format;
    }

    @Override
    public IValidationResult validate(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return IValidationResult.valid();
        }
        try {
            this.format.parse(value);
            return IValidationResult.valid();
        }
        catch (Throwable exception) {
            return IValidationResult.inValid(exception.getLocalizedMessage());
        }
    }
}

