/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.enumeration;

import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public final class EnumerationStringValidator
implements IValidator<String> {
    private final Class clazz;

    public EnumerationStringValidator(Class clazz) {
        if (clazz == null || !clazz.isEnum()) {
            throw new IllegalArgumentException();
        }
        this.clazz = clazz;
    }

    @Override
    public IValidationResult validate(String value) {
        try {
            if (!StringUtilities.isNullOrEmpty(value)) {
                Enum.valueOf(this.clazz, value);
                return IValidationResult.valid();
            }
            return IValidationResult.inValid("Illegale value");
        }
        catch (Exception exception) {
            return IValidationResult.inValid(exception.getLocalizedMessage());
        }
    }
}

