/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.utilities.io.CharEncoding;
import net.anwiba.commons.utilities.io.ICharEncoding;

public class CodePageReader {
    private static ILogger logger = Logging.getLogger((String)CodePageReader.class.getName());
    private final IResourceReferenceHandler resourceReferenceHandler;

    public CodePageReader(IResourceReferenceHandler resourceReferenceHandler) {
        this.resourceReferenceHandler = resourceReferenceHandler;
    }

    public ICharEncoding read(IResourceReference codepageResource, ICharEncoding defaultEncoding) {
        if (codepageResource == null) {
            return defaultEncoding;
        }
        if (this.resourceReferenceHandler.canRead(codepageResource)) {
            try {
                String content = this.resourceReferenceHandler.getContent(codepageResource);
                return Optional.ofNullable(CharEncoding.getByName(content.trim())).orElseGet(() -> defaultEncoding);
            }
            catch (IOException exception) {
                logger.log(ILevel.DEBUG, "Couldn't read " + this.resourceReferenceHandler.toString(codepageResource), (Throwable)exception);
                return defaultEncoding;
            }
        }
        return defaultEncoding;
    }

    public Charset read(IResourceReference codepageResource, Charset defaultCharset) {
        if (codepageResource == null) {
            return defaultCharset;
        }
        if (this.resourceReferenceHandler.canRead(codepageResource)) {
            try {
                String content = this.resourceReferenceHandler.getContent(codepageResource);
                return Optional.ofNullable(Charset.forName(content.trim())).orElseGet(() -> defaultCharset);
            }
            catch (IOException exception) {
                logger.log(ILevel.DEBUG, "Couldn't read " + this.resourceReferenceHandler.toString(codepageResource), (Throwable)exception);
                return defaultCharset;
            }
        }
        return defaultCharset;
    }
}

