/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Properties;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.parameter.Parameters;
import net.anwiba.commons.lang.parameter.ParametersBuilder;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;

public class DefinitionReader {
    private static ILogger logger = Logging.getLogger((String)DefinitionReader.class.getName());
    private final IResourceReferenceHandler resourceReferenceHandler;

    public DefinitionReader(IResourceReferenceHandler resourceReferenceHandler) {
        this.resourceReferenceHandler = resourceReferenceHandler;
    }

    public IParameters read(IResourceReference definitionResource, Charset charset) {
        if (definitionResource == null) {
            return Parameters.empty();
        }
        if (this.resourceReferenceHandler.canRead(definitionResource)) {
            IParameters iParameters;
            InputStreamReader reader = new InputStreamReader(this.resourceReferenceHandler.openInputStream(definitionResource), charset);
            try {
                ParametersBuilder builder = Parameters.builder();
                Properties properties = new Properties();
                properties.load(reader);
                properties.entrySet().forEach(e -> builder.add((String)e.getKey(), (String)e.getValue()));
                iParameters = builder.build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, "Couldn't read " + this.resourceReferenceHandler.toString(definitionResource), (Throwable)exception);
                    return Parameters.empty();
                }
            }
            ((Reader)reader).close();
            return iParameters;
        }
        return Parameters.empty();
    }
}

