/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.anwiba.commons.lang.functional.IClosableIterator;
import net.anwiba.commons.lang.functional.IConsumer;

public interface IClosableIoIterator<T>
extends Closeable,
IClosableIterator<T, IOException> {
    public static <T> IClosableIoIterator<T> empty() {
        return new IClosableIoIterator<T>(){

            @Override
            public void close() throws IOException {
            }

            public T next() throws IOException {
                throw new NoSuchElementException();
            }

            public boolean hasNext() throws IOException {
                return false;
            }
        };
    }

    public static <T> IClosableIoIterator<T> of(final Iterator<T> iterator) {
        return new IClosableIoIterator<T>(){

            public boolean hasNext() throws IOException {
                return iterator.hasNext();
            }

            public T next() throws IOException {
                return iterator.next();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    default public void foreach(IConsumer<? super T, IOException> action) throws IOException {
        Objects.requireNonNull(action);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            action.consume(t);
        }
    }
}

