/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import net.anwiba.commons.utilities.math.AngleUnit;
import net.anwiba.commons.utilities.math.MathWrapper;

public final class Angle {
    public static final double TWO_PI = Math.PI * 2;
    public static final double RHO_DEGREE = 57.29577951308232;
    public static final double RHO_GON = 63.66197723675813;
    public static final double RHO_SEMI_CIRCLE = 0.3183098861837907;
    private static final double OMEGA = 1.0E-7;
    private final double value;

    public static Angle of(double value, AngleUnit unit) {
        switch (unit) {
            case DEGREE: {
                return Angle.degree(value);
            }
            case GON: {
                return Angle.gon(value);
            }
            case RADIAN: {
                return Angle.radian(value);
            }
            case SEMI_CIRCLE: {
                return Angle.semiCircle(value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Angle radian(double x) {
        return new Angle(x);
    }

    public static Angle gon(double value) {
        return new Angle(value / 63.66197723675813);
    }

    public static Angle degree(double value) {
        return new Angle(value / 57.29577951308232);
    }

    public static Angle semiCircle(double value) {
        return new Angle(value / 0.3183098861837907);
    }

    public static Angle degree(int degree, int minute, double second) {
        return Angle.degree((double)degree + (double)minute / 60.0 + second / 3600.0);
    }

    public static Angle fullCircle() {
        return Angle.radian(Math.PI * 2);
    }

    public Angle() {
        this.value = 0.0;
    }

    private Angle(double value) {
        this.value = value % (Math.PI * 2);
    }

    public double radian() {
        return this.value;
    }

    public double degree() {
        return this.radian() * 57.29577951308232;
    }

    public double gon() {
        return this.radian() * 63.66197723675813;
    }

    public double arcSeconds() {
        return this.degree() * 3600.0;
    }

    public double semiCircle() {
        return this.radian() * 0.3183098861837907;
    }

    public double as(AngleUnit unit) {
        return this.radian() * unit.fromRadians();
    }

    private boolean isUndefined() {
        return Double.isNaN(this.value) || Double.isInfinite(this.value);
    }

    public boolean isFullCircle() {
        return Math.abs(this.value) > Math.PI * 2 || Math.abs(this.value) > 1.0E-7 && Angle.moduloPositive(1.0E-7) < 1.0E-7;
    }

    public Angle divide(double divider) {
        if (this.isUndefined() || Double.isNaN(divider)) {
            return Angle.radian(Double.NaN);
        }
        return Angle.radian(this.value / divider);
    }

    public Angle multiply(double factor) {
        if (this.isUndefined() || Double.isNaN(factor)) {
            return Angle.radian(Double.NaN);
        }
        return Angle.radian(this.value * factor);
    }

    public Angle add(Angle angle) {
        if (this.isUndefined() || angle.isUndefined()) {
            return Angle.radian(Double.NaN);
        }
        return Angle.radian(Angle.moduloPositive(this.radian()) + angle.moduloPositive().radian());
    }

    public Angle subtract(Angle angle) {
        if (this.isUndefined() || angle.isUndefined()) {
            return Angle.radian(Double.NaN);
        }
        return Angle.radian(Angle.moduloPositive(this.radian()) - angle.moduloPositive().radian());
    }

    public Angle moduloPositive() {
        if (this.isUndefined()) {
            return this;
        }
        return Angle.radian(Angle.moduloPositive(this.radian()));
    }

    private static double moduloPositive(double radian) {
        return radian > 0.0 ? radian % (Math.PI * 2) : radian % (Math.PI * 2) + Math.PI * 2;
    }

    public Angle moduloNegativ() {
        if (this.isUndefined()) {
            return this;
        }
        return Angle.radian(Angle.moduloNegativ(this.radian()));
    }

    private static double moduloNegativ(double radian) {
        return radian < 0.0 ? radian % (Math.PI * 2) : radian % (Math.PI * 2) - Math.PI * 2;
    }

    public static double sin(Angle value) {
        return MathWrapper.sin(value.radian());
    }

    public static double cos(Angle value) {
        return MathWrapper.cos(value.radian());
    }

    public static double tan(Angle value) {
        return MathWrapper.tan(value.radian());
    }

    public Angle modulo() {
        if (this.isUndefined()) {
            return Angle.radian(Double.NaN);
        }
        return Angle.radian(this.value % (Math.PI * 2));
    }
}

