/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AngleUnit {
    RADIAN{

        @Override
        public double toRadians() {
            return 1.0;
        }

        @Override
        public double fromRadians() {
            return 1.0;
        }
    }
    ,
    DEGREE{

        @Override
        public double toRadians() {
            return Math.PI / 180;
        }

        @Override
        public double fromRadians() {
            return 57.29577951308232;
        }
    }
    ,
    GON{

        @Override
        public double toRadians() {
            return 0.015707963;
        }

        @Override
        public double fromRadians() {
            return 63.661977237;
        }
    }
    ,
    SEMI_CIRCLE{

        @Override
        public double toRadians() {
            return 6.283185307;
        }

        @Override
        public double fromRadians() {
            return 0.318309886;
        }
    };


    public abstract double toRadians();

    public abstract double fromRadians();
}

