/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import net.anwiba.commons.utilities.math.Angle;
import net.anwiba.commons.utilities.math.MathWrapper;

public final class Complex
extends Number {
    private static final long serialVersionUID = 1L;
    public static final Complex identity = new Complex(0.0, 1.0);
    private final double real;
    private final double imaginary;

    public Complex(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double real) {
        this(real, 0.0);
    }

    public Complex(Complex other) {
        this(other.real(), other.imaginary());
    }

    public Complex(Angle phi) {
        this(Angle.cos(phi), Angle.sin(phi));
    }

    public Complex(double real, Angle phi) {
        this(real * Angle.cos(phi), real * Angle.sin(phi));
    }

    public double real() {
        return this.real;
    }

    public double imaginary() {
        return this.imaginary;
    }

    public Complex conjugate() {
        return new Complex(this.real(), -this.imaginary());
    }

    public boolean isReal() {
        return 1.0E-12 > MathWrapper.abs(this.imaginary());
    }

    public double magnitude() {
        return MathWrapper.sqrt(this.real * this.real + this.imaginary * this.imaginary);
    }

    @Override
    public double doubleValue() {
        if (!this.isReal()) {
            return 0.0;
        }
        return this.real();
    }

    @Override
    public float floatValue() {
        if (!this.isReal()) {
            return 0.0f;
        }
        return (float)this.real();
    }

    @Override
    public long longValue() {
        if (!this.isReal()) {
            return 0L;
        }
        return (long)this.real();
    }

    @Override
    public int intValue() {
        if (!this.isReal()) {
            return 0;
        }
        return (int)this.real();
    }

    public Angle angle() {
        Angle result = new Angle();
        try {
            result = Angle.radian(MathWrapper.atan2(this.imaginary, this.real));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Complex add(Complex value) {
        return new Complex(this.real + value.real(), this.imaginary + value.imaginary());
    }

    public Complex add(double value) {
        return new Complex(this.real() + value, this.imaginary());
    }

    public Complex subtract(Complex value) {
        return new Complex(this.real - value.real(), this.imaginary - value.imaginary());
    }

    public Complex subtract(double value) {
        return new Complex(this.real() - value, this.imaginary());
    }

    public Complex multiply(Complex factor) {
        return new Complex(this.real * factor.real() - this.imaginary * factor.imaginary(), this.real * factor.imaginary() + this.imaginary * factor.real());
    }

    public Complex multiply(double factor) {
        return new Complex(factor * this.real, factor * this.imaginary);
    }

    public Complex divide(Complex fraction) throws IllegalStateException {
        double magnitude = fraction.magnitude();
        if (MathWrapper.abs(magnitude) < 1.0E-12) {
            throw new IllegalStateException("denominator is zero");
        }
        return new Complex((this.real * fraction.real() + this.imaginary * fraction.imaginary()) / (magnitude * magnitude), (this.imaginary * fraction.real() - this.real * fraction.imaginary()) / (magnitude * magnitude));
    }

    public static Complex sin(Complex value) {
        double r = MathWrapper.sin(value.real()) * MathWrapper.cosh(value.imaginary());
        double i = MathWrapper.cos(value.real()) * MathWrapper.sinh(value.imaginary());
        return new Complex(r, i);
    }

    public static Complex cos(Complex value) {
        double r = MathWrapper.cos(value.real()) * MathWrapper.cosh(value.imaginary());
        double i = -MathWrapper.sin(value.real()) * MathWrapper.sinh(value.imaginary());
        return new Complex(r, i);
    }

    public static Complex tan(Complex value) {
        double denominator = MathWrapper.cos(2.0 * value.real()) + MathWrapper.cosh(2.0 * value.imaginary());
        double r = MathWrapper.sin(2.0 * value.real()) / denominator;
        double i = MathWrapper.sinh(2.0 * value.imaginary()) / denominator;
        return new Complex(r, i);
    }

    public static Complex pow(Complex value) {
        double exponent = MathWrapper.pow(Math.E, value.real());
        return new Complex(exponent * MathWrapper.cos(value.imaginary()), exponent * MathWrapper.sin(value.imaginary()));
    }

    public static Complex sinh(Complex value) {
        return new Complex(Complex.pow(value).subtract(Complex.pow(value.multiply(-1.0))).multiply(0.5));
    }

    public static Complex cosh(Complex value) {
        double r = Complex.cosh(value.real()) * MathWrapper.cos(value.imaginary());
        double i = Complex.sinh(value.real()) * MathWrapper.sin(value.imaginary());
        return new Complex(r, i);
    }

    public static Complex tanh(Complex value) {
        return new Complex(Complex.sinh(value).divide(Complex.cosh(value)));
    }

    public static double tanh(double value) {
        return new Complex(value, 0.0).real();
    }

    public static Complex atan(Complex value) {
        Complex fraction = value.multiply(identity).add(1.0).divide(value.multiply(identity).multiply(-1.0).add(1.0));
        return new Complex(identity.multiply(-0.5).multiply(Complex.ln(fraction)));
    }

    public static double sinh(double value) {
        return 0.5 * (MathWrapper.exp(value) - MathWrapper.exp(-value));
    }

    public static double cosh(double value) {
        return 0.5 * (MathWrapper.exp(value) + MathWrapper.exp(-value));
    }

    public static Complex exp(Complex value) {
        double rr = MathWrapper.exp(value.real()) * MathWrapper.cos(value.imaginary());
        double ii = MathWrapper.exp(value.real()) * MathWrapper.sin(value.imaginary());
        return new Complex(rr, ii);
    }

    public static Complex ln(Complex value) {
        double rr = MathWrapper.log(value.magnitude()) / MathWrapper.log(Math.E);
        double ii = value.angle().radian();
        return new Complex(rr, ii);
    }

    public static Complex sqrt(Complex value) {
        double magnitude = MathWrapper.sqrt(value.magnitude());
        double phi = value.angle().radian() / 2.0;
        return new Complex(magnitude * MathWrapper.cos(phi), magnitude * MathWrapper.sin(phi));
    }

    public static Complex asin(Complex value) {
        Complex _value = new Complex(1.0, 0.0).subtract(value.multiply(value));
        _value = Complex.sqrt(_value);
        _value = _value.add(identity.multiply(value));
        _value = identity.multiply(Complex.ln(_value)).multiply(-1.0);
        return _value;
    }

    public static Complex atanh(Complex value) {
        Complex _value = value;
        _value = _value.add(1.0).divide(_value.subtract(1.0)).multiply(-1.0);
        _value = Complex.ln(_value).multiply(0.5);
        return _value;
    }

    public static double atanh(double value) {
        return Complex.atanh(new Complex(value, 0.0)).real();
    }

    public String toString() {
        return new String(this.real() + (this.imaginary() < 0.0 ? "-" : "+") + MathWrapper.abs(this.imaginary()) + "i");
    }
}

