/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import java.util.Arrays;
import net.anwiba.commons.utilities.math.MathWrapper;

public class Matrix {
    private final double[][] values;
    private final int n;
    private final int m;

    public static Matrix matrix(double[][] values) {
        return new Matrix(values.length, values.length > 0 ? values[0].length : 0, values);
    }

    public Matrix(int n, int m, double[][] values) {
        this.n = n;
        this.m = m;
        this.values = values;
    }

    public int n() {
        return this.n;
    }

    public int m() {
        return this.m;
    }

    public double[][] values() {
        return this.values;
    }

    public Matrix multiply(double value) {
        return Matrix.matrix(Matrix.multiply(this.n, this.m, value, this.values));
    }

    public Matrix multiply(Matrix other) {
        if (other.n != this.m) {
            throw new IllegalArgumentException();
        }
        return Matrix.matrix(Matrix.multiply(this.n, this.m, other.m, this.values, other.values));
    }

    public static double[][] multiply(int n, int m, int p, double[][] matrix, double[][] other) {
        double[][] result = new double[n][p];
        double[] otherVector = new double[m];
        double sum = 0.0;
        for (int j = 0; j < p; ++j) {
            for (int k = 0; k < m; ++k) {
                otherVector[k] = other[k][j];
            }
            for (int i = 0; i < n; ++i) {
                double[] vector = matrix[i];
                sum = 0.0;
                for (int k = 0; k < m; ++k) {
                    sum += vector[k] * otherVector[k];
                }
                result[i][j] = sum;
            }
        }
        return result;
    }

    private void check(Matrix other) {
        if (other.m != this.m || other.n != this.n) {
            throw new IllegalArgumentException();
        }
    }

    public Matrix summate(double value) {
        return Matrix.matrix(Matrix.summate(this.n, this.m, this.values, value));
    }

    public Matrix summate(Matrix other) {
        this.check(other);
        return Matrix.matrix(Matrix.summate(this.n, this.m, this.values, other.values));
    }

    public Matrix subtract(double value) {
        return Matrix.matrix(Matrix.subtract(this.n, this.m, this.values, value));
    }

    public Matrix subtract(Matrix other) {
        this.check(other);
        return Matrix.matrix(Matrix.subtract(this.n, this.m, this.values, other.values));
    }

    public static double[][] copy(int n, int m, double[][] source) {
        double[][] result = new double[n][m];
        Matrix.copy(n, m, source, result);
        return result;
    }

    public static void copy(int n, int m, double[][] source, double[][] target) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                target[i][j] = source[i][j];
            }
        }
    }

    public static double[][] identityZ(int n) {
        double[][] result = new double[n][n];
        double d = -1.0 / (double)n;
        double e = 1.0 + d;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                result[i][j] = i != j ? d : e;
            }
        }
        return result;
    }

    public static double[][] identity(int n) {
        double[][] result = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                result[i][j] = i != j ? 0.0 : 1.0;
            }
        }
        return result;
    }

    public static double[][] transpose(double[][] source) {
        return Matrix.transpose(source.length, source[0].length, source);
    }

    public static double[][] transpose(int n, int m, double[][] source) {
        double[][] result = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                result[i][j] = source[j][i];
            }
        }
        return result;
    }

    public static double[][] multiply(int n, int m, double scal, double[][] source) {
        double[][] result = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                result[i][j] = scal * source[i][j];
            }
        }
        return result;
    }

    public static double[] multiply(int n, int m, double[][] matrix, double[] vector) {
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                int n2 = i;
                result[n2] = result[n2] + matrix[i][j] * vector[j];
            }
        }
        return result;
    }

    public static double[][] summate(int n, int m, double[][] matrix, double[][] other) {
        double[][] result = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                result[i][j] = matrix[i][j] + other[i][j];
            }
        }
        return result;
    }

    public static double[][] summate(int n, int m, double[][] matrix, double value) {
        double[][] result = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                result[i][j] = matrix[i][j] + value;
            }
        }
        return result;
    }

    public static double[][] subtract(int n, int m, double[][] matrix, double[][] other) {
        double[][] result = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                result[i][j] = matrix[i][j] - other[i][j];
            }
        }
        return result;
    }

    public static double[][] subtract(int n, int m, double[][] matrix, double value) {
        double[][] result = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                result[i][j] = matrix[i][j] - value;
            }
        }
        return result;
    }

    public static double trace(int n, int m, double[][] matrix) {
        double result = 0.0;
        for (int i = 0; i < MathWrapper.min(n, m); ++i) {
            result += matrix[i][i];
        }
        return result;
    }

    public static void leftHandAccumulation(int m, int n, double[][] p, double[] d) {
        int l = 0;
        double g = 0.0;
        int i = n - 1;
        while (i >= 0) {
            int j;
            l = i + 1;
            g = d[i];
            if (i < n - 1) {
                for (j = l; j < n; ++j) {
                    p[i][j] = 0.0;
                }
            }
            if (g != 0.0) {
                g = 1.0 / g;
                if (i != n - 1) {
                    for (j = l; j < n; ++j) {
                        double s = 0.0;
                        for (int k = l; k < m; ++k) {
                            s += p[k][i] * p[k][j];
                        }
                        double f = s / p[i][i] * g;
                        for (int k = i; k < m; ++k) {
                            double[] dArray = p[k];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + f * p[k][i];
                        }
                    }
                }
                for (j = i; j < m; ++j) {
                    double[] dArray = p[j];
                    int n3 = i;
                    dArray[n3] = dArray[n3] * g;
                }
            } else {
                for (j = i; j < m; ++j) {
                    p[j][i] = 0.0;
                }
            }
            double[] dArray = p[i];
            int n4 = i--;
            dArray[n4] = dArray[n4] + 1.0;
        }
    }

    public static void rightHandAccumulation(int n, double[][] p, double[][] q, double[] r) {
        int l = n;
        double g = 0.0;
        int i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                int j;
                if (g != 0.0) {
                    for (j = l; j < n; ++j) {
                        q[j][i] = p[i][j] / p[i][l] / g;
                    }
                    for (j = l; j < n; ++j) {
                        int k;
                        double s = 0.0;
                        for (k = l; k < n; ++k) {
                            s += p[i][k] * q[k][j];
                        }
                        for (k = l; k < n; ++k) {
                            double[] dArray = q[k];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + s * q[k][i];
                        }
                    }
                }
                for (j = l; j < n; ++j) {
                    q[j][i] = 0.0;
                    q[i][j] = 0.0;
                }
            }
            q[i][i] = 1.0;
            g = r[i];
            l = i--;
        }
    }

    public static double householderReduction(int m, int n, double[][] p, double[] d, double[] r) {
        double anorm = 0.0;
        int l = 0;
        double g = 0.0;
        double scale = 0.0;
        for (int i = 0; i < n; ++i) {
            int k;
            int k2;
            int j;
            double h;
            int k3;
            double s = 0.0;
            l = i + 1;
            r[i] = scale * g;
            scale = 0.0;
            g = 0.0;
            if (i < m) {
                for (k3 = i; k3 < m; ++k3) {
                    scale += MathWrapper.abs(p[k3][i]);
                }
                if (scale > 0.0) {
                    for (k3 = i; k3 < m; ++k3) {
                        double[] dArray = p[k3];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += p[k3][i] * p[k3][i];
                    }
                    double f = p[i][i];
                    g = -Matrix.sign(MathWrapper.sqrt(s), f);
                    h = f * g - s;
                    p[i][i] = f - g;
                    if (i != n - 1) {
                        for (j = l; j < n; ++j) {
                            s = 0.0;
                            for (k2 = i; k2 < m; ++k2) {
                                s += p[k2][i] * p[k2][j];
                            }
                            f = s / h;
                            for (k2 = i; k2 < m; ++k2) {
                                double[] dArray = p[k2];
                                int n3 = j;
                                dArray[n3] = dArray[n3] + f * p[k2][i];
                            }
                        }
                    }
                    for (k = i; k < m; ++k) {
                        double[] dArray = p[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                    }
                }
            }
            d[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m && i != n - 1) {
                for (k3 = l; k3 < n; ++k3) {
                    scale += MathWrapper.abs(p[i][k3]);
                }
                if (scale != 0.0) {
                    for (k3 = l; k3 < n; ++k3) {
                        double[] dArray = p[i];
                        int n5 = k3;
                        dArray[n5] = dArray[n5] / scale;
                        s += p[i][k3] * p[i][k3];
                    }
                    double f = p[i][l];
                    g = -Matrix.sign(MathWrapper.sqrt(s), f);
                    h = f * g - s;
                    p[i][l] = f - g;
                    for (k = l; k < n; ++k) {
                        r[k] = p[i][k] / h;
                    }
                    if (i != m - 1) {
                        for (j = l; j < m; ++j) {
                            s = 0.0;
                            for (k2 = l; k2 < n; ++k2) {
                                s += p[j][k2] * p[i][k2];
                            }
                            for (k2 = l; k2 < n; ++k2) {
                                double[] dArray = p[j];
                                int n6 = k2;
                                dArray[n6] = dArray[n6] + s * r[k2];
                            }
                        }
                    }
                    k = l;
                    while (k < n) {
                        double[] dArray = p[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = MathWrapper.max(anorm, MathWrapper.abs(d[i]) + MathWrapper.abs(r[i]));
        }
        return anorm;
    }

    static double radius(double u, double v) {
        double absV;
        double absU = MathWrapper.abs(u);
        if (absU > (absV = MathWrapper.abs(v))) {
            double w = absV / absU;
            return absU * MathWrapper.sqrt(1.0 + w * w);
        }
        if (absV > 0.0) {
            double w = absU / absV;
            return absV * MathWrapper.sqrt(1.0 + w * w);
        }
        return 0.0;
    }

    static double sign(double u, double v) {
        return v >= 0.0 ? MathWrapper.abs(u) : -MathWrapper.abs(u);
    }

    public static void diagonalization(int maxNumberOfIterations, int m, int n, double[][] p, double[] d, double[][] q, double[] r, double anorm) {
        boolean flag = false;
        int nm = 0;
        int l = 0;
        block0: for (int k = n - 1; k >= 0; --k) {
            for (int iteration = 0; iteration < maxNumberOfIterations; ++iteration) {
                flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l - 1;
                    if (MathWrapper.abs(r[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (MathWrapper.abs(d[nm]) + anorm == anorm) break;
                }
                if (flag) {
                    double s = 1.0;
                    for (int i = l; i <= k; ++i) {
                        double h;
                        double f = s * r[i];
                        if (MathWrapper.abs(f) + anorm == anorm) continue;
                        double g = d[i];
                        d[i] = h = Matrix.radius(f, g);
                        h = 1.0 / h;
                        s = -f * h;
                        Matrix.foo(nm, i, m, p, g * h, s);
                    }
                }
                if (l == k) {
                    if (!(d[k] < 0.0)) continue block0;
                    d[k] = -d[k];
                    for (int j = 0; j < n; ++j) {
                        q[j][k] = -q[j][k];
                    }
                    continue block0;
                }
                if (iteration == maxNumberOfIterations) {
                    return;
                }
                nm = k - 1;
                Matrix.qrTransformation(l, k, n, m, nm, p, q, d, r);
            }
        }
    }

    public static void qrTransformation(int l, int k, int n, int m, int k_1, double[][] p, double[][] q, double[] d, double[] r) {
        double x = d[l];
        double r_k = r[k];
        double f = ((d[k_1] - d[k]) * (d[k_1] + d[k]) + (r[k_1] - r_k) * (r[k_1] + r_k)) / (2.0 * r_k * d[k_1]);
        f = ((x - d[k]) * (x + d[k]) + r_k * (d[k_1] / (f + Matrix.sign(Matrix.radius(f, 1.0), f)) - r_k)) / x;
        double c = 1.0;
        double s = 1.0;
        for (int j = l; j <= k_1; ++j) {
            double z;
            int i = j + 1;
            double y = d[i];
            double h = s * r[i];
            double g = c * r[i];
            r[j] = z = Matrix.radius(f, h);
            c = f / z;
            s = h / z;
            f = x * c + g * s;
            g = g * c - x * s;
            h = y * s;
            y *= c;
            Matrix.foo(j, i, n, q, c, s);
            d[j] = z = Matrix.radius(f, h);
            if (z != 0.0) {
                z = 1.0 / z;
                c = f * z;
                s = h * z;
            }
            f = c * g + s * y;
            x = c * y - s * g;
            Matrix.foo(j, i, m, p, c, s);
        }
        r[l] = 0.0;
        r[k] = f;
        d[k] = x;
    }

    private static void foo(int j, int i, int m, double[][] p, double c, double s) {
        for (int k = 0; k < m; ++k) {
            double x = p[k][i];
            double y = p[k][j];
            p[k][j] = y * c + x * s;
            p[k][i] = x * c - y * s;
        }
    }

    public static double singularValueDecomposition(int maxNumberOfIterations, int m, int n, double[][] a, double[][] p, double[] d, double[][] q) {
        double[] r = new double[n];
        Matrix.copy(n, n, a, p);
        double anorm = Matrix.householderReduction(m, n, p, d, r);
        Matrix.rightHandAccumulation(n, p, q, r);
        Matrix.leftHandAccumulation(m, n, p, d);
        Matrix.diagonalization(maxNumberOfIterations, m, n, p, d, q, r, anorm);
        return anorm;
    }

    public static double[] oneVector(int m) {
        double[] result = new double[m];
        Arrays.fill(result, 1.0);
        return result;
    }

    public static double[][] fill(double[][] ds) {
        int dim = MathWrapper.max(ds.length, ds[0].length);
        double[][] result = new double[dim][dim];
        for (int i = 0; i < ds.length; ++i) {
            for (int j = 0; j < ds[i].length; ++j) {
                result[i][j] = ds[i][j];
            }
        }
        return result;
    }

    public double get(int i, int j) {
        return this.values[i][j];
    }
}

