/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.name;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.anwiba.commons.lang.functional.IConverter;

public class UniqueNameBuilder {
    private final Set<String> existingNames = new HashSet<String>();
    private final IConverter<String, String, RuntimeException> namePrepareConverter;
    private final int maxLength;

    public UniqueNameBuilder(IConverter<String, String, RuntimeException> namePrepareTransformer) {
        this(10, namePrepareTransformer, new ArrayList<String>());
    }

    public UniqueNameBuilder(IConverter<String, String, RuntimeException> namePrepareTransformer, Collection<String> attributeBlackList) {
        this(10, namePrepareTransformer, attributeBlackList);
    }

    public UniqueNameBuilder(int maxLength, IConverter<String, String, RuntimeException> nameConverter, Collection<String> attributeBlackList) {
        this.maxLength = maxLength;
        this.namePrepareConverter = nameConverter;
        if (attributeBlackList != null) {
            attributeBlackList.forEach(n -> this.build((String)nameConverter.convert(n)));
        }
    }

    public String build(String name) {
        int i = 0;
        while (true) {
            String validName;
            if (!this.existingNames.contains(validName = this.createValidName(name, i))) {
                this.existingNames.add(validName);
                return validName;
            }
            ++i;
        }
    }

    private String createValidName(String name, int index) {
        String preparedName = (String)this.namePrepareConverter.convert((Object)name);
        if (this.maxLength <= 0 || Integer.MAX_VALUE == this.maxLength) {
            if (index == 0) {
                return preparedName;
            }
            String append = "_" + index;
            return preparedName.replaceAll("_[0-9]*$", "") + append;
        }
        if (index == 0) {
            return this.getCroppedString(preparedName, this.maxLength);
        }
        String append = "_" + index;
        return this.getCroppedString(preparedName.replaceAll("_[0-9]*$", ""), this.maxLength - append.length()) + append;
    }

    private String getCroppedString(String name, int maximumLength) {
        return name.substring(0, Math.min(name.length(), maximumLength));
    }
}

