/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.property;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.property.IProperty;
import net.anwiba.commons.utilities.property.Properties;
import net.anwiba.commons.utilities.property.Property;

public final class PropertiesBuilder {
    private final Map<String, IProperty> properties = new LinkedHashMap<String, IProperty>();

    PropertiesBuilder() {
    }

    PropertiesBuilder(IProperties properties) {
        Streams.of(properties.properties()).foreach(p -> this.properties.put(p.getName(), (IProperty)p));
    }

    public PropertiesBuilder put(String name, String value) {
        return this.put(new Property(name, value));
    }

    public PropertiesBuilder put(IProperty property) {
        this.properties.put(property.getName(), property);
        return this;
    }

    public IProperties build() {
        return new Properties(new ArrayList<IProperty>(this.properties.values()));
    }

    public PropertiesBuilder consume(Consumer<PropertiesBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public PropertiesBuilder putIfAbsent(String name, String value) {
        return this.putIfAbsent(new Property(name, value));
    }

    private PropertiesBuilder putIfAbsent(Property property) {
        this.properties.putIfAbsent(property.getName(), property);
        return this;
    }

    public PropertiesBuilder putIfAbsentIgnoreCase(String name, String value) {
        return this.putIfAbsentIgnoreCase(new Property(name, value));
    }

    private PropertiesBuilder putIfAbsentIgnoreCase(Property property) {
        if (this.properties.keySet().stream().anyMatch(k -> k.equalsIgnoreCase(property.getName()))) {
            return this;
        }
        this.properties.put(property.getName(), property);
        return this;
    }
}

