/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.util.regex.Pattern;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.ResolvingException;
import net.anwiba.commons.utilities.provider.IContextValueProvider;
import net.anwiba.commons.utilities.regex.DoNothingStringConverter;
import net.anwiba.commons.utilities.regex.tokenizer.IRegExpTokenConverter;
import net.anwiba.commons.utilities.regex.tokenizer.RegExpTokenizingConverter;
import net.anwiba.commons.utilities.string.IStringAppender;
import net.anwiba.commons.utilities.string.IStringResolver;
import net.anwiba.commons.utilities.string.StringAppender;

public class AbstractStringResolver
implements IStringResolver {
    protected final IStringAppender errorHandler;
    private final IContextValueProvider<String, String, RuntimeException> provider;
    private final Pattern pattern;
    private final IConverter<String, String, ConversionException> valueConverter;

    public AbstractStringResolver(IStringAppender errorHandler, IConverter<String, String, ConversionException> valueConverter, Pattern pattern, IContextValueProvider<String, String, RuntimeException> contextValueProvider) {
        this.errorHandler = errorHandler;
        this.valueConverter = valueConverter;
        this.pattern = pattern;
        this.provider = contextValueProvider;
    }

    public String resolve(String value) throws ResolvingException {
        return this.resolve(value, this.errorHandler);
    }

    private String resolve(String value, final IStringAppender errorHandler) throws ResolvingException {
        try {
            if (value == null) {
                return null;
            }
            final Pattern pattern = this.pattern;
            RegExpTokenizingConverter converter = new RegExpTokenizingConverter(new IRegExpTokenConverter(){

                @Override
                public String convert(String[] groups) {
                    String name = groups[1];
                    String defaultValue = groups.length > 2 ? groups[2] : null;
                    return AbstractStringResolver.this.getValue(name, defaultValue, errorHandler);
                }

                @Override
                public Pattern getRegExpPattern() {
                    return pattern;
                }
            }, new DoNothingStringConverter());
            return converter.convert((String)this.valueConverter.convert((Object)value), new StringAppender());
        }
        catch (ConversionException exception) {
            throw new ResolvingException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    String getValue(String name, String defaultValue, IStringAppender errorHandler) {
        String value = this.provider.getValue(name);
        if (defaultValue == null && value == null) {
            errorHandler.append(name);
            return "";
        }
        return value != null ? value : defaultValue;
    }
}

