/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.utilities.string.IStringSubstituter;
import net.anwiba.commons.utilities.string.StringUtilities;

public class StringToSystemPropertiesSubstituter
implements IStringSubstituter {
    private final List<IConverter<String, String, RuntimeException>> converters = new LinkedList<IConverter<String, String, RuntimeException>>();
    private final Supplier<Properties> propertiesSupplier;

    public StringToSystemPropertiesSubstituter(List<String> propertyNames) {
        this(propertyNames, () -> System.getProperties());
    }

    public StringToSystemPropertiesSubstituter(List<String> propertyNames, Supplier<Properties> propertiesSupplier) {
        this.propertiesSupplier = propertiesSupplier;
        propertyNames.forEach(property -> this.converters.add((IConverter<String, String, RuntimeException>)((IConverter)s -> {
            if (StringUtilities.isNullOrTrimmedEmpty(s)) {
                return s;
            }
            String value = this.propertiesSupplier.get().getProperty((String)property);
            if (StringUtilities.isNullOrTrimmedEmpty(value)) {
                return s;
            }
            return this.replaceAllIn((String)s, value, "$SYSTEM{" + property + "}");
        })));
    }

    @Override
    public String substitute(String string) {
        return (String)Streams.of(this.converters).aggregate((Object)string, (value, converter) -> (String)converter.convert(value)).get();
    }

    private String replaceAllIn(String string, String value, String replacement) {
        int index = string.indexOf(value);
        if (index == -1) {
            return string;
        }
        String prefix = string.substring(0, index);
        String suffix = string.substring(index + value.length(), string.length());
        return prefix + replacement + this.replaceAllIn(suffix, value, replacement);
    }
}

