/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.time.ILocalDateTimeRange;
import net.anwiba.commons.utilities.time.LocalDateTimeRange;
import net.anwiba.commons.utilities.time.RelativeLocalDateTimeRange;
import net.anwiba.commons.utilities.time.TimeUnit;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

public class LocalDateTimeSegment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final LocalDateTime time;
    private final int resolution;
    private final TimeUnit unit;
    private final ILocalDateTimeRange timeRange;

    public LocalDateTimeSegment(LocalDateTime time, int resolution, TimeUnit unit) {
        this.time = time;
        this.timeRange = null;
        this.resolution = resolution;
        this.unit = unit;
    }

    public LocalDateTimeSegment(ILocalDateTimeRange timeRange, int resolution, TimeUnit unit) {
        this.time = null;
        this.timeRange = timeRange;
        this.resolution = resolution;
        this.unit = unit;
    }

    public LocalDateTime getTime() {
        return (LocalDateTime)Optional.of((Object)this.time).getOr(() -> (LocalDateTime)Optional.of((Object)this.timeRange).convert(r -> this.convert((ILocalDateTimeRange)r)).getOr(() -> UserDateTimeUtilities.now().toLocalDateTime()));
    }

    private LocalDateTime convert(ILocalDateTimeRange range) {
        return range.getFrom();
    }

    public int getDuration() {
        return this.resolution;
    }

    public TimeUnit getTimeUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.time, this.timeRange, this.resolution, this.unit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalDateTimeSegment)) {
            return false;
        }
        LocalDateTimeSegment other = (LocalDateTimeSegment)obj;
        return Objects.equals(this.time, other.time) && Objects.equals(this.timeRange, other.timeRange) && this.resolution == other.resolution && this.unit == other.unit;
    }

    public ILocalDateTimeRange toLocalDateTimeRange() {
        return (ILocalDateTimeRange)Optional.of((Object)this.timeRange).getOr(() -> (ILocalDateTimeRange)Optional.of((Object)this.time).convert(t -> new LocalDateTimeRange((LocalDateTime)t, t.plus(this.resolution, this.unit.toTemporalUnit()))).get());
    }

    public boolean isRelative() {
        return this.timeRange instanceof RelativeLocalDateTimeRange;
    }
}

