/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;

public class LocalDateTimeUtilities {
    public static final LocalDateTime ZERO_DATE_TIME = LocalDateTime.of(0, 1, 1, 0, 0, 0);

    public static LocalDateTime atCoordinatedUniversalTimeZone(ZonedDateTime dateTime) {
        return LocalDateTimeUtilities.atZone(dateTime, ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }

    public static LocalDateTime atZone(ZonedDateTime dateTime, ZoneId targetZone) {
        return dateTime.toInstant().atZone(targetZone).toLocalDateTime();
    }

    public static LocalDateTime atZone(java.sql.Date date, ZoneId zone) {
        return LocalDateTimeUtilities.atZone(new Date(date.getTime()), zone);
    }

    public static LocalDateTime atZone(Date date, ZoneId zone) {
        return LocalDateTime.ofInstant(date.toInstant(), zone);
    }

    public static LocalDateTime atZone(LocalDateTime sourceDateTime, ZoneId sourceZone, ZoneId targetZone) {
        if (sourceDateTime == null) {
            return null;
        }
        if (Objects.equals(sourceZone, targetZone)) {
            return sourceDateTime;
        }
        ZonedDateTime zonedSourceDateTime = sourceDateTime.atZone(sourceZone);
        ZonedDateTime zonedTargetDateTime = zonedSourceDateTime.toInstant().atZone(targetZone);
        return zonedTargetDateTime.toLocalDateTime();
    }

    public static String toString(LocalDateTime dateTime) {
        return dateTime.format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter(Locale.getDefault())).toFormatter(Locale.getDefault()));
    }

    public static String toString(LocalDate date) {
        return date.format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).toFormatter(Locale.getDefault()));
    }

    public static String toString(LocalTime time) {
        return time.format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter(Locale.getDefault()));
    }

    public static LocalDateTime atCoordinatedUniversalTimeZone(java.sql.Date date) {
        return LocalDateTimeUtilities.atCoordinatedUniversalTimeZone(new Date(date.getTime()));
    }

    private static LocalDateTime atCoordinatedUniversalTimeZone(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }

    public static LocalDateTime truncat(LocalDateTime dateTime, TemporalAmount duration, TemporalUnit unit) {
        if (ChronoUnit.SECONDS.getDuration().compareTo(unit.getDuration()) >= 0) {
            LocalDateTime truncated = dateTime.truncatedTo(unit);
            long mod = (long)truncated.getSecond() % duration.get(ChronoUnit.SECONDS);
            return truncated.minus(mod, unit);
        }
        if (ChronoUnit.MINUTES.getDuration().compareTo(unit.getDuration()) >= 0) {
            LocalDateTime truncated = dateTime.truncatedTo(unit);
            long mod = (long)truncated.getMinute() % (duration.get(ChronoUnit.SECONDS) / 60L);
            return truncated.minus(mod, unit);
        }
        if (ChronoUnit.HOURS.getDuration().compareTo(unit.getDuration()) >= 0) {
            LocalDateTime truncated = dateTime.truncatedTo(unit);
            long mod = (long)truncated.getHour() % (duration.get(ChronoUnit.SECONDS) / 3600L);
            return truncated.minus(mod, unit);
        }
        if (ChronoUnit.DAYS.getDuration().compareTo(unit.getDuration()) >= 0) {
            LocalDate truncated = dateTime.toLocalDate();
            int days = (int)duration.get(ChronoUnit.DAYS);
            if (days == 0) {
                return LocalDateTime.of(truncated.minusDays(truncated.getDayOfMonth() - 1), LocalTime.ofSecondOfDay(0L));
            }
            int mod = (truncated.getDayOfMonth() - 1) % days;
            return LocalDateTime.of(truncated.minusDays(mod), LocalTime.ofSecondOfDay(0L));
        }
        if (ChronoUnit.MONTHS.getDuration().compareTo(unit.getDuration()) >= 0) {
            LocalDate truncated = dateTime.toLocalDate().withDayOfMonth(1);
            int mod = (truncated.getMonthValue() - 1) % (int)duration.get(ChronoUnit.MONTHS);
            return LocalDateTime.of(truncated.minusMonths(mod), LocalTime.ofSecondOfDay(0L));
        }
        LocalDate truncated = dateTime.toLocalDate().withDayOfMonth(1).withDayOfMonth(1);
        int mod = truncated.getYear() % (int)duration.get(ChronoUnit.YEARS);
        return LocalDateTime.of(truncated.minusYears(mod), LocalTime.ofSecondOfDay(0L));
    }
}

