/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import net.anwiba.commons.utilities.time.ILocalDateTimeRange;
import net.anwiba.commons.utilities.time.LocalDateTimeRange;
import net.anwiba.commons.utilities.time.TemporalAmountUtilities;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

public class RelativeLocalDateTimeRange
implements ILocalDateTimeRange {
    private static final long serialVersionUID = 1L;
    private final TemporalAmount from;
    private final TemporalAmount until;
    private final TemporalUnit resolution;

    public static RelativeLocalDateTimeRange today() {
        return new RelativeLocalDateTimeRange(Period.ofDays(0), Period.ofDays(1), ChronoUnit.DAYS);
    }

    public static RelativeLocalDateTimeRange of(TemporalAmount from, int duration, TemporalUnit unit) {
        return new RelativeLocalDateTimeRange(from, TemporalAmountUtilities.plus(from, duration, unit), unit);
    }

    public static RelativeLocalDateTimeRange minutes(long minutes) {
        return new RelativeLocalDateTimeRange(Duration.ofMinutes(0L), Duration.ofMinutes(minutes), ChronoUnit.MINUTES);
    }

    public static RelativeLocalDateTimeRange hours(long hours) {
        return new RelativeLocalDateTimeRange(Duration.ofHours(0L), Duration.ofHours(hours), ChronoUnit.HOURS);
    }

    public static RelativeLocalDateTimeRange days(int days) {
        return new RelativeLocalDateTimeRange(Period.ofDays(0), Period.ofDays(days), ChronoUnit.DAYS);
    }

    public static RelativeLocalDateTimeRange months(int months) {
        return new RelativeLocalDateTimeRange(Period.ofMonths(0), Period.ofMonths(months), ChronoUnit.MONTHS);
    }

    public static RelativeLocalDateTimeRange years(int years) {
        return new RelativeLocalDateTimeRange(Period.ofYears(0), Period.ofYears(years), ChronoUnit.YEARS);
    }

    public static ILocalDateTimeRange of(long value, TemporalUnit temporalUnit) {
        if (!(temporalUnit instanceof ChronoUnit)) {
            throw new IllegalArgumentException();
        }
        ChronoUnit timeUnit = (ChronoUnit)temporalUnit;
        switch (timeUnit) {
            case YEARS: {
                return RelativeLocalDateTimeRange.years((int)value);
            }
            case MONTHS: {
                return RelativeLocalDateTimeRange.months((int)value);
            }
            case DAYS: {
                return RelativeLocalDateTimeRange.days((int)value);
            }
            case HOURS: {
                return RelativeLocalDateTimeRange.hours(value);
            }
            case MINUTES: {
                return RelativeLocalDateTimeRange.minutes(value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static RelativeLocalDateTimeRange of(TemporalAmount from, TemporalAmount until, TemporalUnit unit) {
        TemporalAmount _until;
        TemporalAmount _from = TemporalAmountUtilities.floor(from, unit);
        if (Objects.equals(_from, _until = TemporalAmountUtilities.floor(until, unit))) {
            return new RelativeLocalDateTimeRange(_from, TemporalAmountUtilities.plus(_until, 1L, unit), unit);
        }
        return new RelativeLocalDateTimeRange(_from, _until, unit);
    }

    private RelativeLocalDateTimeRange(TemporalAmount from, TemporalAmount until, TemporalUnit resolution) {
        this.from = from;
        this.until = until;
        this.resolution = resolution;
    }

    final TemporalUnit getUnit() {
        return this.resolution;
    }

    @Override
    public LocalDateTime getFrom() {
        return this.now().plus(this.from);
    }

    @Override
    public LocalDateTime getUntil() {
        return this.now().plus(this.until);
    }

    @Override
    public LocalDateTime getCenter() {
        return this.getFrom().plus(Duration.between(this.getFrom(), this.getUntil()).dividedBy(2L));
    }

    @Override
    public TemporalAmount getDuration() {
        if (this.resolution.isDateBased()) {
            return Period.between(this.getFrom().toLocalDate(), this.getUntil().toLocalDate());
        }
        return Duration.between(this.getFrom(), this.getUntil());
    }

    @Override
    public boolean interact(LocalDateTime time) {
        if (time == null) {
            return false;
        }
        return (this.getFrom().isBefore(time) || this.getFrom().isEqual(time)) && this.getUntil().isAfter(time);
    }

    @Override
    public boolean interact(ILocalDateTimeRange segment) {
        if (segment == null) {
            return false;
        }
        if (segment.getUntil().equals(this.getFrom()) || segment.getUntil().isBefore(this.getFrom())) {
            return false;
        }
        return !segment.getFrom().equals(this.getUntil()) && !segment.getFrom().isAfter(this.getUntil());
    }

    @Override
    public ILocalDateTimeRange intersection(ILocalDateTimeRange segment) {
        if (!this.interact(segment)) {
            return null;
        }
        LocalDateTime _from = segment.getFrom().isAfter(this.getFrom()) ? segment.getFrom() : this.getFrom();
        LocalDateTime _until = segment.getUntil().isBefore(this.getUntil()) ? segment.getUntil() : this.getUntil();
        return new LocalDateTimeRange(_from, _until);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.until, this.resolution);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelativeLocalDateTimeRange)) {
            return false;
        }
        RelativeLocalDateTimeRange other = (RelativeLocalDateTimeRange)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.until, other.until) && Objects.equals(this.resolution, other.resolution);
    }

    @Override
    public TemporalAmount getDurationFromUntilToNow() {
        LocalDateTime plus;
        LocalDateTime now = this.now();
        if (now.isBefore(plus = now.plus(this.until))) {
            return Duration.between(now, plus);
        }
        return this.until;
    }

    @Override
    public TemporalAmount getDurationFromFromToNow() {
        return this.from;
    }

    private LocalDateTime now() {
        LocalDateTime now = UserDateTimeUtilities.now().toLocalDateTime();
        return TemporalAmountUtilities.floor(now, this.resolution);
    }

    @Override
    public ILocalDateTimeRange duration(long value, TemporalUnit unit) {
        TemporalAmount _from = TemporalAmountUtilities.floor(this.from, unit);
        TemporalAmount _until = TemporalAmountUtilities.plus(this.from, value, unit);
        if (TemporalAmountUtilities.toDateTime(_until).isBefore(TemporalAmountUtilities.toDateTime(_from))) {
            return new RelativeLocalDateTimeRange(this.from, TemporalAmountUtilities.plus(this.until, value, unit), unit);
        }
        return new RelativeLocalDateTimeRange(this.from, _until, unit);
    }

    @Override
    public ILocalDateTimeRange shift(long value, TemporalUnit unit) {
        return new RelativeLocalDateTimeRange(TemporalAmountUtilities.plus(this.from, value, unit), TemporalAmountUtilities.plus(this.until, value, unit), unit);
    }

    @Override
    public ILocalDateTimeRange plus(long value, TemporalUnit unit) {
        TemporalAmount _from = TemporalAmountUtilities.floor(this.from, unit);
        TemporalAmount _until = TemporalAmountUtilities.plus(this.until, value, unit);
        if (TemporalAmountUtilities.toDateTime(_until).isBefore(TemporalAmountUtilities.toDateTime(_from))) {
            return new RelativeLocalDateTimeRange(this.from, TemporalAmountUtilities.plus(this.until, value, unit), unit);
        }
        return new RelativeLocalDateTimeRange(this.from, _until, unit);
    }

    @Override
    public ILocalDateTimeRange minus(long value, TemporalUnit unit) {
        TemporalAmount _from = TemporalAmountUtilities.floor(this.from, unit);
        TemporalAmount _until = TemporalAmountUtilities.minus(this.until, value, unit);
        if (TemporalAmountUtilities.toDateTime(_until).isBefore(TemporalAmountUtilities.toDateTime(_from))) {
            return new RelativeLocalDateTimeRange(this.from, TemporalAmountUtilities.plus(this.until, value, unit), unit);
        }
        return new RelativeLocalDateTimeRange(this.from, _until, unit);
    }

    @Override
    public ILocalDateTimeRange toRelative() {
        return new RelativeLocalDateTimeRange(this.from, this.until, this.resolution);
    }

    @Override
    public ILocalDateTimeRange toAbsolute() {
        return new LocalDateTimeRange(this.getFrom(), this.getUntil());
    }

    @Override
    public ILocalDateTimeRange toRelative(TemporalUnit unit) {
        TemporalAmount _until;
        if (Objects.equals(unit, this.resolution)) {
            return this.toRelative();
        }
        TemporalAmount _from = TemporalAmountUtilities.floor(this.from, unit);
        if (Objects.equals(_from, _until = TemporalAmountUtilities.floor(this.until, unit))) {
            return new RelativeLocalDateTimeRange(_from, TemporalAmountUtilities.plus(_until, 1L, unit), unit);
        }
        return new RelativeLocalDateTimeRange(_from, _until, unit);
    }
}

