/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.format.DateTimeFormatter;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public final class TemporalStringValidator
implements IValidator<String> {
    private final DateTimeFormatter formatter;

    public TemporalStringValidator(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public IValidationResult validate(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return IValidationResult.valid();
        }
        try {
            this.formatter.parse(value);
            return IValidationResult.valid();
        }
        catch (Throwable exception) {
            return IValidationResult.inValid(exception.getMessage());
        }
    }
}

