/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.version;

import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.VersionBuilder;

public class VersionParser {
    public IVersion parse(String string) {
        try {
            if (string == null) {
                return null;
            }
            boolean lastCharaterWasWhiteSpace = false;
            ParseState state = ParseState.UNDEFIND;
            StringBuilder builder = new StringBuilder();
            StringBuilder donebuilder = new StringBuilder();
            VersionBuilder versionBuilder = new VersionBuilder();
            for (char c : string.toCharArray()) {
                donebuilder.append(c);
                ParseState previousState = state;
                if (c == '.') {
                    state = this.point(previousState, builder, versionBuilder);
                    lastCharaterWasWhiteSpace = false;
                } else if (c == '-') {
                    state = this.hyphen(previousState, builder, versionBuilder);
                    lastCharaterWasWhiteSpace = false;
                } else if (c == ':') {
                    state = this.colon(previousState, builder, versionBuilder);
                    lastCharaterWasWhiteSpace = false;
                } else if (Character.isWhitespace(c)) {
                    if (lastCharaterWasWhiteSpace) continue;
                    state = this.checkWhitespace(previousState, builder, versionBuilder);
                    lastCharaterWasWhiteSpace = true;
                } else if (Character.isDigit(c)) {
                    state = this.digit(previousState, builder, versionBuilder);
                    lastCharaterWasWhiteSpace = false;
                } else if (Character.isLetter(c)) {
                    state = this.letter(previousState, builder, versionBuilder);
                    lastCharaterWasWhiteSpace = false;
                }
                if (!state.equals((Object)previousState)) {
                    builder = new StringBuilder();
                }
                if (c == '.' || c == ':' || c == '-' || Character.isWhitespace(c)) continue;
                builder.append(c);
            }
            state = this.resolve(state, builder, versionBuilder);
            return versionBuilder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Couldn't parse " + string, e);
        }
    }

    private ParseState resolve(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
        switch (state) {
            case UNDEFIND: {
                return state;
            }
            case MAJOR: {
                versionBuilder.setMajor(builder.toString());
                return state;
            }
            case MINOR: {
                versionBuilder.setMinor(builder.toString());
                return state;
            }
            case RELEASESTATE: {
                versionBuilder.setReleaseState(builder.toString());
                return state;
            }
            case STEP: {
                versionBuilder.setStep(builder.toString());
                return state;
            }
            case PRODUCTSTATE: {
                versionBuilder.setProductState(builder.toString());
                return state;
            }
            case COUNT: {
                versionBuilder.setCount(builder.toString());
                return state;
            }
            case YEAR: {
                versionBuilder.setYear(builder.toString());
                return state;
            }
            case MONTH: {
                versionBuilder.setMonth(builder.toString());
                return state;
            }
            case DAY: {
                versionBuilder.setDay(builder.toString());
                return state;
            }
            case HOUR: {
                versionBuilder.setHour(builder.toString());
                return state;
            }
            case MIN: {
                versionBuilder.setMinute(builder.toString());
                return state;
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private ParseState checkWhitespace(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
        switch (state) {
            case UNDEFIND: {
                return state;
            }
            case MAJOR: {
                versionBuilder.setMajor(builder.toString());
                return ParseState.RELEASESTATE;
            }
            case MINOR: {
                versionBuilder.setMinor(builder.toString());
                return ParseState.RELEASESTATE;
            }
            case RELEASESTATE: {
                versionBuilder.setReleaseState(builder.toString());
                return ParseState.STEP;
            }
            case STEP: {
                versionBuilder.setStep(builder.toString());
                return ParseState.PRODUCTSTATE;
            }
            case PRODUCTSTATE: {
                versionBuilder.setProductState(builder.toString());
                return ParseState.COUNT;
            }
            case COUNT: {
                versionBuilder.setCount(builder.toString());
                return ParseState.YEAR;
            }
            case YEAR: {
                versionBuilder.setYear(builder.toString());
                return ParseState.HOUR;
            }
            case MONTH: {
                versionBuilder.setMonth(builder.toString());
                return ParseState.HOUR;
            }
            case DAY: {
                versionBuilder.setDay(builder.toString());
                return ParseState.HOUR;
            }
            case HOUR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case MIN: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private ParseState hyphen(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
        switch (state) {
            case UNDEFIND: {
                return state;
            }
            case MAJOR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case MINOR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case RELEASESTATE: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case STEP: {
                versionBuilder.setStep(builder.toString());
                return ParseState.RELEASESTATE;
            }
            case PRODUCTSTATE: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case COUNT: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case YEAR: {
                versionBuilder.setYear(builder.toString());
                return ParseState.MONTH;
            }
            case MONTH: {
                versionBuilder.setMonth(builder.toString());
                return ParseState.DAY;
            }
            case DAY: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case HOUR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case MIN: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private ParseState colon(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
        switch (state) {
            case UNDEFIND: {
                return state;
            }
            case MAJOR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case MINOR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case RELEASESTATE: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case STEP: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case PRODUCTSTATE: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case COUNT: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case YEAR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case MONTH: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case DAY: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case HOUR: {
                versionBuilder.setHour(builder.toString());
                return ParseState.MIN;
            }
            case MIN: {
                throw new IllegalArgumentException();
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private ParseState point(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
        switch (state) {
            case UNDEFIND: {
                return ParseState.MINOR;
            }
            case MAJOR: {
                versionBuilder.setMajor(builder.toString());
                return ParseState.MINOR;
            }
            case MINOR: {
                versionBuilder.setMinor(builder.toString());
                return ParseState.STEP;
            }
            case RELEASESTATE: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case STEP: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case PRODUCTSTATE: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case COUNT: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case YEAR: {
                versionBuilder.setYear(builder.toString());
                return ParseState.MONTH;
            }
            case MONTH: {
                versionBuilder.setMonth(builder.toString());
                return ParseState.DAY;
            }
            case DAY: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case HOUR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case MIN: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private ParseState letter(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
        switch (state) {
            case UNDEFIND: {
                return ParseState.RELEASESTATE;
            }
            case MAJOR: {
                versionBuilder.setMajor(builder.toString());
                return ParseState.RELEASESTATE;
            }
            case MINOR: {
                versionBuilder.setMinor(builder.toString());
                return ParseState.RELEASESTATE;
            }
            case RELEASESTATE: {
                return state;
            }
            case STEP: {
                versionBuilder.setStep(builder.toString());
                return ParseState.PRODUCTSTATE;
            }
            case PRODUCTSTATE: {
                return state;
            }
            case YEAR: {
                throw new IllegalArgumentException();
            }
            case MONTH: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case DAY: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case HOUR: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case MIN: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
            case COUNT: {
                throw new IllegalArgumentException(this.toString(state, builder));
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private ParseState digit(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
        switch (state) {
            case UNDEFIND: {
                return ParseState.MAJOR;
            }
            case MAJOR: {
                return state;
            }
            case MINOR: {
                return state;
            }
            case RELEASESTATE: {
                versionBuilder.setReleaseState(builder.toString());
                return ParseState.STEP;
            }
            case STEP: {
                return state;
            }
            case PRODUCTSTATE: {
                versionBuilder.setProductState(builder.toString());
                return ParseState.YEAR;
            }
            case YEAR: {
                return state;
            }
            case MONTH: {
                return state;
            }
            case DAY: {
                return state;
            }
            case HOUR: {
                return state;
            }
            case MIN: {
                return state;
            }
            case COUNT: {
                return state;
            }
        }
        throw new IllegalArgumentException(this.toString(state, builder));
    }

    private String toString(ParseState state, StringBuilder builder) {
        return "state: " + state + " part:" + builder.toString();
    }

    public static enum ParseState {
        UNDEFIND,
        MAJOR,
        MINOR,
        RELEASESTATE,
        STEP,
        PRODUCTSTATE,
        COUNT,
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MIN;

    }
}

