/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.ormlite;

import java.util.LinkedHashSet;
import java.util.Set;
import net.apexes.commons.ormlite.DatabaseHelper;
import net.apexes.commons.ormlite.Table;

public abstract class AbstractChangeSupport
implements DatabaseHelper.ChangeSupportable {
    private final ThreadLocal<Set<Table<?>>> mThreadLocal = new ThreadLocal();

    protected AbstractChangeSupport() {
    }

    public final void addChange(Table<?> table) {
        Set<Table<?>> tables = this.mThreadLocal.get();
        if (tables == null) {
            tables = new LinkedHashSet();
            this.mThreadLocal.set(tables);
        }
        tables.add(table);
    }

    public final boolean isChange() {
        Set<Table<?>> tables = this.mThreadLocal.get();
        if (tables == null) {
            return false;
        }
        return !tables.isEmpty();
    }

    public final void clearChange() {
        Set<Table<?>> tables = this.mThreadLocal.get();
        if (tables == null) {
            return;
        }
        tables.clear();
    }

    public final void notifyChange() {
        Set<Table<?>> tables = this.mThreadLocal.get();
        if (tables == null) {
            return;
        }
        this.mThreadLocal.set(null);
        this.notifyChange(tables.toArray(new Table[0]));
    }

    protected abstract void notifyChange(Table<?> ... var1);
}

