/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.ormlite;

import android.content.AsyncTaskLoader;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Loader;
import android.database.ContentObserver;
import android.net.Uri;
import android.util.Log;
import com.j256.ormlite.android.apptools.OpenHelperManager;
import java.sql.SQLException;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.ormlite.DatabaseHelper;
import net.apexes.commons.ormlite.SQLiteDatabaseHelper;

public abstract class OrmLiteLoader<T>
extends AsyncTaskLoader<T> {
    private static final String TAG = OrmLiteLoader.class.getSimpleName();
    private final Uri mUri;
    private T mData;
    private ContentObserver mObserver;

    protected OrmLiteLoader(Context context, Uri uri) {
        super(context);
        Checks.verifyNotNull((Object)uri, (String)"uri");
        this.mUri = uri;
    }

    public T loadInBackground() {
        try {
            DatabaseHelper databaseHelper = (DatabaseHelper)OpenHelperManager.getHelper((Context)this.getContext(), this.getHelperClass());
            T t = this.query(databaseHelper);
            return t;
        }
        catch (SQLException ex) {
            Log.w((String)TAG, (String)"Query Error!", (Throwable)ex);
        }
        finally {
            OpenHelperManager.releaseHelper();
        }
        return null;
    }

    public void deliverResult(T data) {
        this.mData = data;
        if (this.isStarted()) {
            super.deliverResult(data);
        }
    }

    protected void onStartLoading() {
        if (this.mData != null) {
            this.deliverResult(this.mData);
        }
        if (this.mObserver == null) {
            this.mObserver = new Loader.ForceLoadContentObserver((Loader)this);
            ContentResolver resolver = this.getContext().getContentResolver();
            resolver.registerContentObserver(this.mUri, true, this.mObserver);
        }
        if (this.takeContentChanged() || this.mData == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        this.onStopLoading();
        if (this.mData != null) {
            this.mData = null;
        }
        if (this.mObserver != null) {
            ContentResolver resolver = this.getContext().getContentResolver();
            resolver.unregisterContentObserver(this.mObserver);
            this.mObserver = null;
        }
    }

    protected abstract <E extends SQLiteDatabaseHelper> Class<E> getHelperClass();

    protected abstract T query(DatabaseHelper var1) throws SQLException;
}

