/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.ormlite;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.util.Log;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import net.apexes.commons.ormlite.AbstractChangeSupport;
import net.apexes.commons.ormlite.DatabaseHelper;
import net.apexes.commons.ormlite.Table;
import net.apexes.commons.ormlite.UpgradeHelper;

public abstract class SQLiteDatabaseHelper
extends OrmLiteSqliteOpenHelper
implements DatabaseHelper {
    private static final String TAG = SQLiteDatabaseHelper.class.getSimpleName();
    private final DatabaseHelper.ChangeSupportable mChangeSupport;

    public SQLiteDatabaseHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion) {
        super(context, databaseName, factory, databaseVersion);
        this.mChangeSupport = this.createChangeSupportable(context);
    }

    public SQLiteDatabaseHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, File configFile) {
        super(context, databaseName, factory, databaseVersion, configFile);
        this.mChangeSupport = this.createChangeSupportable(context);
    }

    public SQLiteDatabaseHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, InputStream stream) {
        super(context, databaseName, factory, databaseVersion, stream);
        this.mChangeSupport = this.createChangeSupportable(context);
    }

    public SQLiteDatabaseHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, int configFileId) {
        super(context, databaseName, factory, databaseVersion, configFileId);
        this.mChangeSupport = this.createChangeSupportable(context);
    }

    protected DatabaseHelper.ChangeSupportable createChangeSupportable(Context context) {
        return new ContentResolverChangeSupport(context);
    }

    public <D extends Dao<E, ?>, E> D dao(Table<E> table) throws SQLException {
        Dao dao;
        Dao castDao = dao = DaoManager.createDao((ConnectionSource)this.getConnectionSource(), (Class)table.dataClass());
        return (D)castDao;
    }

    public <E> E callInTransaction(Callable<E> callable) throws SQLException {
        return (E)TransactionManager.callInTransaction((ConnectionSource)this.getConnectionSource(), callable);
    }

    public DatabaseHelper.ChangeSupportable getChangeSupportable() {
        return this.mChangeSupport;
    }

    public void onCreate(SQLiteDatabase sqliteDatabase, ConnectionSource connectionSource) {
        try {
            for (Table<?> table : this.getTables()) {
                TableUtils.createTable((ConnectionSource)connectionSource, (DatabaseTableConfig)table.getConfig());
            }
        }
        catch (SQLException ex) {
            Log.e((String)TAG, (String)"Unable to create database", (Throwable)ex);
        }
    }

    public void onUpgrade(SQLiteDatabase sqliteDatabase, ConnectionSource connectionSource, int oldVer, int newVer) {
        try {
            UpgradeHelper upgradeHelper = new UpgradeHelper(connectionSource, oldVer, newVer);
            for (Table<?> table : this.getTables()) {
                upgradeHelper.alterTableAppendColumn(table);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Unable to upgrade database from version " + oldVer + " to new " + newVer), (Throwable)ex);
        }
    }

    protected abstract List<Table<?>> getTables();

    protected abstract Uri getUri(Table<?> var1);

    protected class ContentResolverChangeSupport
    extends AbstractChangeSupport {
        private final Context mContext;

        protected ContentResolverChangeSupport(Context context) {
            this.mContext = context;
        }

        protected void notifyChange(Uri uri) {
            this.mContext.getContentResolver().notifyChange(uri, null);
        }

        protected void notifyChange(Table<?> ... tables) {
            for (Table<?> table : tables) {
                this.notifyChange(SQLiteDatabaseHelper.this.getUri(table));
            }
        }
    }
}

