/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.volley;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.toolbox.HttpHeaderParser;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import net.apexes.commons.lang.Checks;

public class GsonRequest<Q, R>
extends Request<R> {
    public static final String PROTOCOL_CHARSET = "utf-8";
    public static final String PROTOCOL_CONTENT_TYPE = "application/json; charset=utf-8";
    private final Q mRequestObject;
    private final Type mResponseType;
    private final Response.Listener<R> mListener;
    private final Gson mGson;
    private ResponseProcessor<R> mProcessor;

    public GsonRequest(String url, Q requestObject, Type responseType, Response.Listener<R> listener, Response.ErrorListener errorListener) {
        this(url, requestObject, responseType, new Gson(), listener, errorListener);
    }

    public GsonRequest(String url, Q requestObject, Type responseType, Gson gson, Response.Listener<R> listener, Response.ErrorListener errorListener) {
        super(1, url, errorListener);
        Checks.verifyNotNull((Object)gson, (String)"gson");
        Checks.verifyNotNull((Object)responseType, (String)"responseType");
        Checks.verifyNotNull(listener, (String)"listener");
        this.mGson = gson;
        this.mRequestObject = requestObject;
        this.mResponseType = responseType;
        this.mListener = listener;
    }

    @Override
    public String getBodyContentType() {
        return PROTOCOL_CONTENT_TYPE;
    }

    @Override
    public byte[] getBody() throws AuthFailureError {
        try {
            String body = this.mGson.toJson(this.mRequestObject);
            return body.getBytes(PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    @Override
    protected void deliverResponse(R response) {
        this.mListener.onResponse(response);
    }

    @Override
    protected Response<R> parseNetworkResponse(NetworkResponse response) {
        try {
            String json = new String(response.data, HttpHeaderParser.parseCharset(response.headers));
            R responseValue = this.toResponseValue(json, this.mResponseType);
            return Response.success(responseValue, HttpHeaderParser.parseCacheHeaders(response));
        }
        catch (Exception e) {
            return Response.error(new ParseError(e));
        }
    }

    protected R toResponseValue(String json, Type responseType) throws Exception {
        Object value = this.mGson.fromJson(json, responseType);
        if (this.mProcessor != null) {
            this.mProcessor.process(value);
        }
        return (R)value;
    }

    public void setResponseProcessor(ResponseProcessor<R> processor) {
        this.mProcessor = processor;
    }

    public static interface ResponseProcessor<R> {
        public R process(R var1);
    }
}

