/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.ormlite;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.util.Log;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import java.io.File;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import net.apexes.commons.ormlite.AbstractChangeSupport;
import net.apexes.commons.ormlite.DatabaseHelper;
import net.apexes.commons.ormlite.DatabaseUtil;
import net.apexes.commons.ormlite.SqliteUpgrader;
import net.apexes.commons.ormlite.Table;

public abstract class SQLiteDatabaseHelper
extends OrmLiteSqliteOpenHelper
implements DatabaseHelper {
    private static final String TAG = SQLiteDatabaseHelper.class.getSimpleName();
    private final DatabaseHelper.ChangeSupportable mChangeSupport;

    public SQLiteDatabaseHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion) {
        super(context, databaseName, factory, databaseVersion);
        this.mChangeSupport = this.createChangeSupportable(context);
    }

    public SQLiteDatabaseHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, File configFile) {
        super(context, databaseName, factory, databaseVersion, configFile);
        this.mChangeSupport = this.createChangeSupportable(context);
    }

    public SQLiteDatabaseHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, InputStream stream) {
        super(context, databaseName, factory, databaseVersion, stream);
        this.mChangeSupport = this.createChangeSupportable(context);
    }

    public SQLiteDatabaseHelper(Context context, String databaseName, SQLiteDatabase.CursorFactory factory, int databaseVersion, int configFileId) {
        super(context, databaseName, factory, databaseVersion, configFileId);
        this.mChangeSupport = this.createChangeSupportable(context);
    }

    protected DatabaseHelper.ChangeSupportable createChangeSupportable(Context context) {
        return new ContentResolverChangeSupport(context);
    }

    public <T, ID> Dao<T, ID> dao(Table<T> table) throws SQLException {
        return DatabaseUtil.dao((ConnectionSource)this.getConnectionSource(), table);
    }

    public <E> E callInTransaction(Callable<E> callable) throws SQLException {
        return (E)DatabaseUtil.callInTransaction((ConnectionSource)this.getConnectionSource(), callable);
    }

    public DatabaseHelper.ChangeSupportable getChangeSupportable() {
        return this.mChangeSupport;
    }

    public void onCreate(SQLiteDatabase sqliteDatabase, ConnectionSource connectionSource) {
        try {
            this.checkSqliteDatabase(sqliteDatabase);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Unable to create database", (Throwable)ex);
        }
    }

    public void onUpgrade(SQLiteDatabase sqliteDatabase, ConnectionSource connectionSource, int oldVer, int newVer) {
        try {
            this.checkSqliteDatabase(sqliteDatabase);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Unable to upgrade database from version " + oldVer + " to new " + newVer), (Throwable)ex);
        }
    }

    protected void checkSqliteDatabase(SQLiteDatabase db) throws Exception {
        SqliteUpgrader upgrader = new SqliteUpgrader(db, this.getTables());
        upgrader.upgrade(this.getConnectionSource());
    }

    protected abstract List<Table<?>> getTables();

    protected abstract Uri getUri(Table<?> var1);

    protected class ContentResolverChangeSupport
    extends AbstractChangeSupport {
        private final Context mContext;

        protected ContentResolverChangeSupport(Context context) {
            this.mContext = context;
        }

        protected void notifyChange(Uri uri) {
            this.mContext.getContentResolver().notifyChange(uri, null);
        }

        protected void notifyChange(Table<?> ... tables) {
            for (Table<?> table : tables) {
                this.notifyChange(SQLiteDatabaseHelper.this.getUri(table));
            }
        }
    }
}

