/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.ormlite;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.ConnectionSource;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.ormlite.Column;
import net.apexes.commons.ormlite.ForeignKey;
import net.apexes.commons.ormlite.Index;
import net.apexes.commons.ormlite.Table;
import net.apexes.commons.ormlite.UpgradeChecker;
import net.apexes.commons.ormlite.UpgradeHelper;

public class SqliteUpgrader
implements UpgradeChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SqliteUpgrader.class);
    private final SQLiteDatabase db;
    private final List<Table<?>> tables;

    public SqliteUpgrader(SQLiteDatabase db, List<Table<?>> tables) {
        this.db = db;
        this.tables = tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgrade(ConnectionSource connectionSource) throws Exception {
        this.db.beginTransaction();
        try {
            UpgradeHelper upgradeHelper = new UpgradeHelper(connectionSource, (UpgradeChecker)this);
            for (Table<?> table : this.tables) {
                upgradeHelper.upgrade(table);
                this.upgradeIndex(table);
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void upgradeIndex(Table<?> table) throws Exception {
        String sql;
        StringBuilder sb;
        Class<?> tableClass = table.getClass();
        HashMap<String, String> needCreateMap = new HashMap<String, String>();
        HashMap<String, Boolean> nameUniqueMap = new HashMap<String, Boolean>();
        Field ixsField = null;
        try {
            ixsField = tableClass.getField("ix");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ixsField != null) {
            Object ixs = ixsField.get(table);
            for (Field field : ixs.getClass().getFields()) {
                if (!Index.class.isAssignableFrom(field.getType())) continue;
                Index ix = (Index)field.get(ixs);
                String ixName = ix.name().toUpperCase();
                sb = new StringBuilder();
                List ics = ix.columns();
                for (int i = 0; i < ics.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    Index.IndexColumn ic = (Index.IndexColumn)ics.get(i);
                    sb.append(ic.getColumn().name().toUpperCase());
                    if (!ic.isDesc()) continue;
                    sb.append(" DESC");
                }
                needCreateMap.put(sb.toString(), ixName);
                nameUniqueMap.put(ixName, ix.isUnique());
            }
        }
        Field fksField = null;
        try {
            fksField = tableClass.getField("fk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fksField != null) {
            void var10_17;
            Object fks = fksField.get(table);
            Field[] fieldArray = fks.getClass().getFields();
            int n = fieldArray.length;
            boolean bl = false;
            while (var10_17 < n) {
                ForeignKey fk;
                String columnName;
                Field field = fieldArray[var10_17];
                if (ForeignKey.class.isAssignableFrom(field.getType()) && !needCreateMap.containsKey(columnName = (fk = (ForeignKey)field.get(fks)).column().name().toUpperCase())) {
                    String indexName = "IX_" + table.name() + "_PK_" + columnName;
                    indexName = indexName.toUpperCase();
                    needCreateMap.put(columnName, indexName);
                    nameUniqueMap.put(indexName, false);
                }
                ++var10_17;
            }
        }
        HashSet<String> needDeleteNames = new HashSet<String>();
        String selectSql = "select name, sql from sqlite_master" + " where type='index' and sql is not null" + " and tbl_name='" + table.name() + "'";
        try (Cursor cursor = this.db.rawQuery(selectSql, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String string = cursor.getString(0).trim().toUpperCase();
                    sql = cursor.getString(1).trim().toUpperCase();
                    boolean unique = sql.contains(" UNIQUE ");
                    String columnInfo = this.parseColumn(sql);
                    String needCreateName = (String)needCreateMap.get(columnInfo);
                    if (needCreateName == null) {
                        needDeleteNames.add(string);
                    } else if (((Boolean)nameUniqueMap.get(needCreateName)).booleanValue()) {
                        if (unique) {
                            needCreateMap.remove(columnInfo);
                            nameUniqueMap.remove(needCreateName);
                        } else {
                            needDeleteNames.add(string);
                        }
                    } else if (unique) {
                        needDeleteNames.add(string);
                    } else {
                        needCreateMap.remove(columnInfo);
                        nameUniqueMap.remove(needCreateName);
                    }
                    if (!nameUniqueMap.containsKey(string)) continue;
                    needDeleteNames.add(string);
                }
            }
        }
        if (Checks.isNotEmpty(needDeleteNames)) {
            for (String string : needDeleteNames) {
                sql = "DROP INDEX IF EXISTS " + string;
                LOG.info(sql);
                this.db.execSQL(sql);
            }
        }
        if (Checks.isNotEmpty(needCreateMap)) {
            for (Map.Entry entry : needCreateMap.entrySet()) {
                String columnInfo = (String)entry.getKey();
                String indexName = (String)entry.getValue();
                sb = new StringBuilder();
                sb.append("DROP INDEX IF EXISTS ").append(indexName);
                String dropSql = sb.toString();
                LOG.info(dropSql);
                this.db.execSQL(dropSql);
                sb.setLength(0);
                if (((Boolean)nameUniqueMap.get(indexName)).booleanValue()) {
                    sb.append("CREATE UNIQUE INDEX ");
                } else {
                    sb.append("CREATE INDEX ");
                }
                sb.append(indexName).append(" ON ").append(table.name()).append(" (").append(columnInfo).append(")");
                String createSql = sb.toString();
                LOG.info(createSql);
                this.db.execSQL(createSql);
            }
        }
    }

    private String parseColumn(String sql) {
        StringBuilder sb = new StringBuilder();
        int bi = sql.indexOf("(") + 1;
        int ei = sql.indexOf(")");
        String allColumnInfo = sql.substring(bi, ei);
        String[] columnInfoArr = allColumnInfo.split(",");
        for (int i = 0; i < columnInfoArr.length; ++i) {
            String columnInfo;
            int iDesc;
            if (i > 0) {
                sb.append(", ");
            }
            if ((iDesc = (columnInfo = columnInfoArr[i].trim()).indexOf(" DESC")) > 0) {
                String columnName = columnInfo.substring(0, iDesc).trim();
                sb.append(columnName).append(" DESC");
                continue;
            }
            int iSpace = columnInfo.indexOf(" ");
            if (iSpace > 0) {
                String columnName = columnInfo.substring(0, iSpace).trim();
                sb.append(columnName);
                continue;
            }
            sb.append(columnInfo);
        }
        return sb.toString();
    }

    public boolean exists(ConnectionSource connectionSource, Table<?> table) throws Exception {
        String selectSql = "select count(*) as c from sqlite_master" + " where type='table' and tbl_name='" + table.name() + "'";
        try (Cursor cursor = this.db.rawQuery(selectSql, null);){
            boolean bl = cursor != null && cursor.moveToNext() && cursor.getInt(0) > 0;
            return bl;
        }
    }

    public boolean exists(ConnectionSource connectionSource, Column column, Field field) throws Exception {
        String selectSql = "select * from " + column.table().name() + " limit 0";
        try (Cursor cursor = this.db.rawQuery(selectSql, null);){
            boolean bl = cursor != null && cursor.getColumnIndex(column.name()) != -1;
            return bl;
        }
    }
}

