/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.eventbus;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.apexes.commons.eventbus.AnnotationEventFilter;
import net.apexes.commons.eventbus.AnnotationPriority;
import net.apexes.commons.eventbus.EventFilter;
import net.apexes.commons.eventbus.EventFilterChain;
import net.apexes.commons.eventbus.IEventFilter;
import net.apexes.commons.eventbus.IPriority;
import net.apexes.commons.eventbus.IPublisher;
import net.apexes.commons.eventbus.PriorityHub;
import net.apexes.commons.eventbus.PriorityList;

public class EventBusFilter
extends PriorityHub {
    private final IPublisher publisher;
    private static final String CHAIN_IMPL_CLASS_NAME = EventFilterChainImpl.class.getName();

    public EventBusFilter(IPublisher publisher) {
        super(IEventFilter.class);
        EventBusFilter.verifyNotNull(publisher, "publisher");
        this.publisher = publisher;
    }

    public <T> void register(String address, IEventFilter<T> filter) {
        EventBusFilter.verifyNotNull(address, "address");
        EventBusFilter.verifyNotNull(filter, "filter");
        super.register(address, filter);
    }

    public <T> void unregister(String address, IEventFilter<T> filter) {
        EventBusFilter.verifyNotNull(address, "address");
        EventBusFilter.verifyNotNull(filter, "filter");
        super.unregister(address, filter);
    }

    @Override
    protected Set<AnnotationPriority> getAnnotationPrioritys(Object object) {
        Method[] methods;
        LinkedHashSet<AnnotationPriority> filters = new LinkedHashSet<AnnotationPriority>();
        Class<?> clazz = object.getClass();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(EventFilter.class)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 2) {
                throw new IllegalArgumentException("The method is invalid. method=" + method);
            }
            Class<?> chainParamType = parameterTypes[1];
            if (!EventFilterChain.class.isAssignableFrom(chainParamType)) {
                throw new IllegalArgumentException("The method is invalid. method=" + method);
            }
            AnnotationEventFilter filter = new AnnotationEventFilter(object, method);
            filters.add(filter);
        }
        return filters;
    }

    @Override
    protected <E> void doPost(String address, E event, PriorityList<E> prioritys) {
        EventFilterChainImpl<E> chain = new EventFilterChainImpl<E>(this.publisher, address, prioritys);
        chain.next(event);
    }

    private static class EventFilterChainImpl<E>
    implements EventFilterChain<E> {
        private final IPublisher publisher;
        private final String address;
        private final Iterator<IPriority<E>> iterator;
        private final Set<String> callerNames;

        EventFilterChainImpl(IPublisher publisher, String address, PriorityList<E> prioritys) {
            this.publisher = publisher;
            this.address = address;
            this.iterator = prioritys.iterator();
            this.callerNames = new HashSet<String>();
        }

        @Override
        public void next(E event) {
            String callerName = this.getCallerName();
            if (this.callerNames.contains(callerName)) {
                throw new IllegalStateException();
            }
            this.callerNames.add(callerName);
            if (this.iterator.hasNext()) {
                IEventFilter filter = (IEventFilter)this.iterator.next();
                filter.filter(event, this);
            } else {
                this.publisher.publish(this.address, event);
            }
        }

        private String getCallerName() {
            StackTraceElement frame;
            String className;
            int i;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (i = 0; i < stack.length && !(className = (frame = stack[i]).getClassName()).equals(CHAIN_IMPL_CLASS_NAME); ++i) {
            }
            while (i < stack.length) {
                frame = stack[i];
                className = frame.getClassName();
                if (!className.equals(CHAIN_IMPL_CLASS_NAME)) {
                    return String.format("%s.%s", className, frame.getMethodName());
                }
                ++i;
            }
            return null;
        }
    }
}

