/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.eventbus;

import com.squareup.otto.DeadEvent;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.apexes.commons.eventbus.AnnotationPriority;
import net.apexes.commons.eventbus.IPriority;
import net.apexes.commons.eventbus.PriorityList;

abstract class PriorityHub {
    private final Class<?> priorityClass;
    private final Map<String, PriorityList<?>> prioritysMap;
    private final Map<Object, Set<AnnotationPriority>> annotationsMap;

    protected PriorityHub(Class<?> priorityClass) {
        this.priorityClass = priorityClass;
        this.prioritysMap = new ConcurrentHashMap();
        this.annotationsMap = new ConcurrentHashMap<Object, Set<AnnotationPriority>>();
    }

    public void register(Object object) {
        PriorityHub.verifyNotNull(object, "object");
        if (this.annotationsMap.containsKey(object)) {
            throw new IllegalArgumentException("This object is be registered.");
        }
        if (this.priorityClass.isInstance(object)) {
            IPriority priority = (IPriority)object;
            String address = PriorityHub.getAddress(priority, this.priorityClass);
            this.register(address, priority);
        } else {
            Set<AnnotationPriority> prioritys = this.getAnnotationPrioritys(object);
            if (!prioritys.isEmpty()) {
                this.annotationsMap.put(object, prioritys);
                for (AnnotationPriority priority : prioritys) {
                    this.register(priority.getAddress(), priority);
                }
            }
        }
    }

    protected <E> void register(String address, IPriority<E> priority) {
        PriorityList<E> prioritys = this.getPriorityList(address);
        if (prioritys == null) {
            prioritys = new PriorityList();
            this.prioritysMap.put(address, prioritys);
        } else if (prioritys.contains(priority)) {
            throw new IllegalArgumentException("Be registered.");
        }
        prioritys.add(priority);
    }

    public void unregister(Object object) {
        PriorityHub.verifyNotNull(object, "object");
        if (object instanceof IPriority) {
            IPriority priority = (IPriority)object;
            String address = PriorityHub.getAddress(priority, this.priorityClass);
            this.unregister(address, priority);
        } else {
            Set<AnnotationPriority> prioritys = this.annotationsMap.get(object);
            if (prioritys != null) {
                for (AnnotationPriority priority : prioritys) {
                    this.unregister(priority.getAddress(), priority);
                }
                this.annotationsMap.remove(object);
            }
        }
    }

    protected <E> void unregister(String address, IPriority<E> priority) {
        PriorityList<E> prioritys = this.getPriorityList(address);
        if (priority == null) {
            throw new IllegalArgumentException("Not registered.");
        }
        prioritys.remove(priority);
        if (prioritys.isEmpty()) {
            this.prioritysMap.remove(address);
        }
    }

    public <E> void post(E event) {
        PriorityHub.verifyNotNull(event, "event");
        this.post(event.getClass().getName(), event);
    }

    public <E> void post(String address, E event) {
        PriorityHub.verifyNotNull(address, "address");
        PriorityHub.verifyNotNull(event, "event");
        PriorityList<E> prioritys = this.getPriorityList(address);
        if (prioritys != null && !prioritys.isEmpty()) {
            this.doPost(address, event, prioritys);
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent((Object)this, event));
        }
    }

    protected <E> PriorityList<E> getPriorityList(String address) {
        return this.prioritysMap.get(address);
    }

    protected abstract Set<AnnotationPriority> getAnnotationPrioritys(Object var1);

    protected abstract <E> void doPost(String var1, E var2, PriorityList<E> var3);

    static String getAddress(IPriority<?> priority, Class<?> classType) {
        Class<?> clazz = priority.getClass();
        do {
            try {
                Type[] types;
                for (Type type : types = clazz.getGenericInterfaces()) {
                    ParameterizedType ptype;
                    if (!(type instanceof ParameterizedType) || !classType.equals((ptype = (ParameterizedType)type).getRawType())) continue;
                    Type cmpType = ptype.getActualTypeArguments()[0];
                    Class cmpClazz = cmpType instanceof ParameterizedType ? (Class)((ParameterizedType)cmpType).getRawType() : (Class)ptype.getActualTypeArguments()[0];
                    return cmpClazz.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return Object.class.getName();
    }

    static void verifyNotNull(Object obj, String paramName) {
        if (obj == null) {
            throw new IllegalArgumentException("The " + paramName + " must be not null.");
        }
    }
}

